<?php
/**
 * Extansion version
 *
 * @package     Wow_Plugin
 * @subpackage
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$pro_url  = 'https://wow-estore.com/item/wow-modal-windows-pro/';
$demo_url = 'https://wow-company.com/modal-windows-pro/';
?>

<section class="section" id="features">
    <div class="container">
        <div class="block has-text-centered ds-title">
            <p class="subtitle is-5 is-uppercase has-text-danger">what you get</p>
            <h3 class="title is-2">Awesome Features </h3>
            <div class="button-group">
                <a href="<?php echo esc_url( $pro_url ); ?>" class="like-button pro-button" target="_blank">Get More
                    with Pro</a>
                <a href="<?php echo esc_url( $demo_url ); ?>" class="like-button demo-button" target="_blank">Demo</a>
            </div>
        </div>

        <div class="features-content">

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-bullseye fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Triggers</h4>
                    <p>Add additional triggers to open a popup such as: <b>Page load</b>, <b>Click
                            on
                            button</b>, <b>Hover on element</b>, <b>Exit intent</b>, <b>Right Click</b>, <b>Select
                            Text</b>, <b>Scrolling</b></p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-hand-paper fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Forced Interaction</h4>
                    <p>Disabling the close button can be used in a variety of ways, from
                        protecting content
                        or areas of your site to forcing users to complete an action before continuing.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-external-link-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Redirect visitor on close</h4>
                    <p>Defines if the visitor gets redirected to another URL after popup gets
                        closed.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-calendar-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Scheduling</h4>
                    <p>Add scheduling options to your popups. With multiple schedule types,
                        you can
                        precisely schedule your popups in just a few minutes.</p>
                </div>
            </div>

            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-swatchbook fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Animation</h4>
                    <p>28 different animations for show and hide popup and overlay. Make the
                        appearance of
                        your popup more attractive.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-play-circle fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Video Support</h4>
                    <p>Create the ultimate WordPress Video Popup for your marketing videos in
                        minutes -
                        customize your player, control video autoplay and close.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-window-close fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Auto Close</h4>
                    <p>This will help you lock the screen for some time so that the user can
                        read the
                        necessary information.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-greater-than-equal fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Show after</h4>
                    <p>Show if another popup already converted.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-toggle-on fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Show only once</h4>
                    <p>Show the modal window only once for user.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-shapes fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Different Floating Button</h4>
                    <p>This will help you lock the screen for some time so that the user can
                        read the
                        necessary information.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fab fa-wpforms fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Form</h4>
                    <p>Insert the default form in popup content and customize the style.
                        Integrate the form
                        with popular Email Marketing Services: <b>MailChimp</b>, <b>AWeber</b>,
                        <b>ActiveCampaign</b>,
                        <b>SendinBlue</b>, <b>GetResponse</b></p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-palette fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Highly Customizable</h4>
                    <p>Build a more powerful and influential style for your modal windows -
                        add background
                        images, add font style for popup title, content and close button, set different
                        close button position.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-eye fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Display on Taxonomy</h4>
                    <p>The ability to display pop-ups only in taxonomies. Works with
                        WooCommerce, EDD and
                        other plugins with taxonomy.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-users fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">User dependence</h4>
                    <p>Show popup depending on user (for all users, only for logged-in users,
                        only for not
                        logged-in
                        users).</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-pen-fancy fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Live Editor</h4>
                    <p>Creating the popup style live.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-laptop fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Devices control</h4>
                    <p>You can specify for which devices to show the popup.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-language fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Multi language</h4>
                    <p>The condition for display the popup depending on the language of the
                        site. It is good
                        to use if you have a website in several languages and you need to show different
                        popups for a different language.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="fas fa-globe fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Browsers</h4>
                    <p>Ability to deactivate the display of popups in selected browsers.</p>
                </div>
            </div>
            <div class="is-flex">
                <div class="mr-4">
                    <div class="fa-stack fa-2x has-text-orange-light">
                        <i class="fas fa-circle fa-stack-2x"></i>
                        <i class="far fa-file-alt fa-stack-1x fa-inverse has-text-orange-dark"></i>
                    </div>
                </div>
                <div class="block">
                    <h4 class="features-title">Specific pages</h4>
                    <p>Show the popup on the specific pages.</p>
                </div>
            </div>

        </div>

    </div>

</section>

